/*
 * Decompiled with CFR 0.152.
 */
package com.esn.CGMServer.DEVICE.RegistratorModule.Registrator.Types.MX2;

import com.esn.CGMServer.DEVICE.RegistratorModule.Registrator.IRegistratorConnector;
import com.esn.CGMServer.DEVICEModule.TDEVICEModule;
import com.esn.CGMServer.Utils.TMemoryInOutStreamAdapter;
import com.intel.bluetooth.BluetoothConsts;
import com.intel.bluetooth.RemoteDeviceHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DataElement;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryListener;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TMX2BTConnector
implements IRegistratorConnector {
    private static final String Holter_Prefix = "Holter";
    private TWirelessDevice Holter = null;
    private StreamConnection Holter_Connection = null;
    private InputStream Holter_IN = null;
    private OutputStream Holter_OUT = null;
    private TReading Holter_Reading = null;

    public static ArrayList<TWirelessDevice> GetDeviceInfo(int Mode2) throws BluetoothStateException, InterruptedException {
        TWirelessDevice[] devices;
        ArrayList<TWirelessDevice> Result2 = new ArrayList<TWirelessDevice>();
        switch (Mode2) {
            case 0: {
                TWirelessDiscoveryDevices.discoverDevices();
                break;
            }
            case 1: {
                TWirelessDiscoveryDevices.discoverCachedDevices();
                break;
            }
            case 2: {
                TWirelessDiscoveryDevices.discoverPreknownDevices();
            }
        }
        for (TWirelessDevice device : devices = TWirelessDiscoveryDevices.getAvailableDevices()) {
            if (!device.friendlyName.startsWith(Holter_Prefix)) continue;
            Result2.add(device);
        }
        return Result2;
    }

    public TMX2BTConnector(String Link) throws Exception {
        String[] LinkSA = Link.split(",");
        if (LinkSA.length < 2) {
            TWirelessDevice[] devices;
            TWirelessDiscoveryDevices.discoverDevices();
            for (TWirelessDevice device : devices = TWirelessDiscoveryDevices.getAvailableDevices()) {
                if (!device.friendlyName.startsWith(Holter_Prefix)) continue;
                this.Holter = device;
                break;
            }
        } else {
            this.Holter = new TWirelessDevice();
            this.Holter.ConnectionURL = LinkSA[1];
        }
        if (this.Holter == null) {
            throw new IRegistratorConnector.RegistratorIsNotFoundException();
        }
    }

    @Override
    public void Connect() throws Exception {
        this.Disconnect();
        boolean flOpen = false;
        int TriesCount = 5;
        for (int I = 0; I < 5; ++I) {
            try {
                String ConnectionURL = this.Holter.getConnectionURL();
                this.Holter_Connection = (StreamConnection)Connector.open(ConnectionURL);
                System.out.println("BT Device is connected at address: " + ConnectionURL);
                flOpen = true;
                break;
            }
            catch (Exception E) {
                Thread.sleep(1000L);
                continue;
            }
        }
        if (!flOpen) {
            throw new IOException("could not open BT Holter device after " + Integer.toString(5) + " tries");
        }
        this.Holter_IN = this.Holter_Connection.openDataInputStream();
        this.Holter_OUT = this.Holter_Connection.openDataOutputStream();
        this.Holter_Reading = new TReading();
    }

    @Override
    public void Disconnect() throws Exception {
        if (this.Holter_Connection != null) {
            this.Holter_OUT.close();
            this.Holter_IN.close();
            this.Holter_Connection.close();
            this.Holter_Reading.Destroy();
            this.Holter_Connection = null;
        }
    }

    @Override
    public boolean IsConnectable() {
        try {
            this.Connect();
            this.Disconnect();
            return true;
        }
        catch (Exception E) {
            return false;
        }
    }

    @Override
    public boolean IsConnected() {
        return this.Holter_Connection != null;
    }

    @Override
    public void Reset() throws Exception {
    }

    @Override
    public void Normalize() {
        this.Holter_Reading.InOutStreamAdapter.Normalize();
    }

    @Override
    public int Reading_Avaiable() throws Exception {
        return this.Holter_Reading.InOutStreamAdapter.Reading_Available();
    }

    @Override
    public int Writing_Avaiable() throws Exception {
        return -1;
    }

    @Override
    public void Reading_Purge() throws Exception {
        this.Holter_Reading.InOutStreamAdapter.Clean(Integer.MAX_VALUE, null);
    }

    @Override
    public void Writing_Purge() throws Exception {
    }

    @Override
    public int Read(byte[] BA, int Size, int Timeout) throws Exception {
        this.Holter_Reading.InOutStreamAdapter.Reading_Timeout = Timeout;
        return this.Holter_Reading.InOutStreamAdapter.Read(BA, 0, Size);
    }

    @Override
    public void Write(byte[] BA, int Size) throws Exception {
        this.Holter_OUT.write(BA, 0, Size);
    }

    private class TReading
    implements Runnable {
        private final Thread thread;
        private boolean flCancelled = false;
        public final TMemoryInOutStreamAdapter InOutStreamAdapter = new TMemoryInOutStreamAdapter(true);

        public TReading() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void Destroy() throws Exception {
            this.flCancelled = true;
            this.thread.join();
            this.InOutStreamAdapter.Destroy();
        }

        @Override
        public void run() {
            try {
                int MaxPacketSize = 1024;
                byte[] Packet = new byte[1024];
                while (!this.flCancelled) {
                    int ReadCount = TMX2BTConnector.this.Holter_IN.read(Packet);
                    if (ReadCount > 0) {
                        this.InOutStreamAdapter.OutStream().write(Packet, 0, ReadCount);
                        continue;
                    }
                    if (ReadCount >= 0) continue;
                    break;
                }
            }
            catch (Exception E) {
                TDEVICEModule.log.error("Device.RegistratorModule.Registrator.Reading.run(): error", E);
            }
        }
    }

    public static class TWirelessDiscoveryDevices {
        public static final Logger logger = LogManager.getLogger(TWirelessDiscoveryDevices.class);
        private static HashMap<RemoteDevice, TWirelessDevice> remoteDeviceToWirelessDevice = new HashMap();
        private static final Object inquiryCompletedEvent = new Object();
        private static final boolean isDebugOutput = true;
        private static final DiscoveryListener listener = new DiscoveryListener(){

            @Override
            public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass cod) {
                logger.debug("Device discovered: ");
                logger.debug(TWirelessParamToString.remoteDeviceToString(remoteDevice));
                logger.debug(TWirelessParamToString.deviceClassToString(cod));
                TWirelessDiscoveryDevices.addRemoteDeviceToWirelessDevices(remoteDevice);
                TWirelessDiscoveryDevices.addDeviceClassOnWirelessDeviceByRemoteDevice(remoteDevice, cod);
            }

            @Override
            public void servicesDiscovered(int transID, ServiceRecord[] serviceRecords) {
                logger.error("servicesDiscovered callback catches in impossible place!");
            }

            @Override
            public void serviceSearchCompleted(int transID, int respCode) {
                logger.error("serviceSearchCompleted callback catches in impossible place!");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void inquiryCompleted(int discType) {
                logger.debug("Inquiry completed.");
                Object object = inquiryCompletedEvent;
                synchronized (object) {
                    inquiryCompletedEvent.notifyAll();
                }
            }
        };

        public static final TWirelessDevice[] getAvailableDevices() {
            if (0 == remoteDeviceToWirelessDevice.size()) {
                return new TWirelessDevice[0];
            }
            TWirelessDevice[] wirelessDevices = new TWirelessDevice[remoteDeviceToWirelessDevice.size()];
            int index = 0;
            for (Map.Entry<RemoteDevice, TWirelessDevice> entry : remoteDeviceToWirelessDevice.entrySet()) {
                if (wirelessDevices.length <= index) break;
                wirelessDevices[index] = entry.getValue();
                ++index;
            }
            return wirelessDevices;
        }

        private static final void addRemoteDeviceToWirelessDevices(RemoteDevice remoteDevice) {
            TWirelessDevice wirelessDevice = new TWirelessDevice();
            wirelessDevice.setRemoteDevice(remoteDevice);
            if (!remoteDeviceToWirelessDevice.containsKey(remoteDevice)) {
                remoteDeviceToWirelessDevice.put(remoteDevice, wirelessDevice);
            }
        }

        private static final void addDeviceClassOnWirelessDeviceByRemoteDevice(RemoteDevice remoteDevice, DeviceClass deviceClass) {
            if (!remoteDeviceToWirelessDevice.containsKey(remoteDevice)) {
                TWirelessDiscoveryDevices.addRemoteDeviceToWirelessDevices(remoteDevice);
            }
            TWirelessDevice wirelessDevice = remoteDeviceToWirelessDevice.get(remoteDevice);
            wirelessDevice.setDeviceClass(deviceClass);
        }

        public static void discoverCachedDevices() throws BluetoothStateException {
            logger.debug("Start discover cached devices...");
            RemoteDevice[] cachedRemoteDevices = LocalDevice.getLocalDevice().getDiscoveryAgent().retrieveDevices(0);
            if (null != cachedRemoteDevices) {
                for (RemoteDevice cachedRemoteDevice : cachedRemoteDevices) {
                    logger.debug("Cached: ");
                    logger.debug(TWirelessParamToString.remoteDeviceToString(cachedRemoteDevice));
                    TWirelessDiscoveryDevices.addRemoteDeviceToWirelessDevices(cachedRemoteDevice);
                }
            }
        }

        public static void discoverPreknownDevices() throws BluetoothStateException {
            logger.debug("Start discover cached devices...");
            RemoteDevice[] preknownRemoteDevices = LocalDevice.getLocalDevice().getDiscoveryAgent().retrieveDevices(1);
            if (null != preknownRemoteDevices) {
                for (RemoteDevice preknownRemoteDevice : preknownRemoteDevices) {
                    logger.debug("Pre-known: ");
                    logger.debug(TWirelessParamToString.remoteDeviceToString(preknownRemoteDevice));
                    TWirelessDiscoveryDevices.addRemoteDeviceToWirelessDevices(preknownRemoteDevice);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void discoverDevices() throws BluetoothStateException, InterruptedException {
            logger.debug("Start discover devices...");
            Object object = inquiryCompletedEvent;
            synchronized (object) {
                boolean started = LocalDevice.getLocalDevice().getDiscoveryAgent().startInquiry(10390323, listener);
                if (started) {
                    inquiryCompletedEvent.wait();
                }
            }
            logger.debug("Discover devices done.");
        }

        public static class TWirelessDiscoveryServices {
            public static final Logger logger = LogManager.getLogger(TWirelessDiscoveryServices.class);
            private final Object serviceSearchCompletedEvent = new Object();
            private RemoteDevice remoteDevice;
            private HashSet<ServiceRecord> serviceRecordHashSet = new HashSet();
            private static final boolean isDebug = false;
            private final DiscoveryListener listener = new DiscoveryListener(){

                @Override
                public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
                    logger.error("deviceDiscovered callback catches in impossible place!");
                }

                @Override
                public void servicesDiscovered(int transID, ServiceRecord[] serviceRecords) {
                    for (ServiceRecord serviceRecord : serviceRecords) {
                        if (serviceRecord.getHostDevice() == remoteDevice) {
                            serviceRecordHashSet.remove(serviceRecord);
                            serviceRecordHashSet.add(serviceRecord);
                            continue;
                        }
                        logger.error("Found service for unknown RemoteDevice ({" + serviceRecord.getHostDevice() + "}).");
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void serviceSearchCompleted(int transID, int respCode) {
                    Object object = serviceSearchCompletedEvent;
                    synchronized (object) {
                        serviceSearchCompletedEvent.notifyAll();
                    }
                }

                @Override
                public void inquiryCompleted(int i) {
                    logger.error("inquiryCompleted callback catches in impossible place!");
                }
            };

            public HashSet<ServiceRecord> getServiceRecordHashSet() {
                return this.serviceRecordHashSet;
            }

            public TWirelessDiscoveryServices(RemoteDevice remoteDevice) {
                this.remoteDevice = remoteDevice;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void discoverServices() throws InterruptedException, BluetoothStateException {
                int transID = 0;
                if (null == this.remoteDevice) {
                    throw new NullPointerException("Can't search services for null RemoteDevice");
                }
                logger.debug("Start discover services on {" + this.remoteDevice.toString() + "}...");
                UUID[] searchUuidSet = new UUID[]{new UUID(4098L)};
                int[] attrIDSet = new int[]{256};
                Object object = this.serviceSearchCompletedEvent;
                synchronized (object) {
                    transID = LocalDevice.getLocalDevice().getDiscoveryAgent().searchServices(attrIDSet, searchUuidSet, this.remoteDevice, this.listener);
                    this.serviceSearchCompletedEvent.wait();
                }
                logger.debug("Done discover services on {" + this.remoteDevice.toString() + "} transaction {" + transID + "}.");
            }
        }
    }

    public static class TWirelessDevice {
        public static final Logger logger = LogManager.getLogger(TWirelessDevice.class);
        public ArrayList<String> serviceURLs;
        public String friendlyName;
        public String macAddressString;
        private RemoteDevice remoteDevice = null;
        private DeviceClass deviceClass = null;
        private TWirelessDiscoveryServices wirelessDiscoveryServices = null;
        private boolean isOpen;
        private static final String lineTerminator = "\r\n";
        private static final String tabulation = "  ";
        public String ConnectionURL = null;

        public TWirelessDevice() {
            Object serviceRecords = null;
            this.friendlyName = "";
            this.macAddressString = "";
            this.serviceURLs = new ArrayList();
            this.isOpen = false;
        }

        public void setRemoteDevice(RemoteDevice remoteDevice) {
            this.remoteDevice = remoteDevice;
            String name = "Friendly name: ";
            try {
                this.friendlyName = remoteDevice.getFriendlyName(false);
                if (null == name) {
                    this.friendlyName = remoteDevice.getFriendlyName(true);
                }
            }
            catch (IOException e) {
                this.friendlyName = "No name";
                logger.error(e.toString(), e);
            }
            this.macAddressString = TWirelessDevice.macAddressToString(remoteDevice.getBluetoothAddress());
        }

        public void setDeviceClass(DeviceClass deviceClass) {
            this.deviceClass = deviceClass;
        }

        public RemoteDevice getRemoteDevice() {
            return this.remoteDevice;
        }

        public void tryPair() throws IOException {
            if (!this.remoteDevice.isAuthenticated()) {
                try {
                    logger.debug("Authenticate " + RemoteDeviceHelper.authenticate(this.remoteDevice, "0000") + " device: " + this.macAddressString);
                }
                catch (IOException e) {
                    logger.error(e.toString(), e);
                }
            }
        }

        private String getFirstSPPURLFromServiceURLs(ArrayList<String> serviceURLs) {
            String url;
            if (0 == serviceURLs.size()) {
                return null;
            }
            String firstValidURL = null;
            Iterator<String> iterator = serviceURLs.iterator();
            while (iterator.hasNext() && (null == (firstValidURL = (url = iterator.next())) || !firstValidURL.contains("btspp://"))) {
            }
            return firstValidURL;
        }

        public String getConnectionURL() throws Exception {
            if (this.ConnectionURL != null) {
                return this.ConnectionURL;
            }
            this.ConnectionURL = this.getFirstSPPURLFromServiceURLs(this.serviceURLs);
            if (null == this.ConnectionURL) {
                if (null == this.wirelessDiscoveryServices) {
                    this.wirelessDiscoveryServices = new TWirelessDiscoveryServices(this.remoteDevice);
                }
                this.wirelessDiscoveryServices.discoverServices();
                for (ServiceRecord serviceRecord : this.wirelessDiscoveryServices.getServiceRecordHashSet()) {
                    String serviceURL = serviceRecord.getConnectionURL(0, false);
                    if (null == serviceURL) continue;
                    this.serviceURLs.add(serviceURL);
                }
                this.ConnectionURL = this.getFirstSPPURLFromServiceURLs(this.serviceURLs);
            }
            if (null == this.ConnectionURL) {
                throw new Exception("No connection URL found");
            }
            if (null != this.ConnectionURL) {
                logger.trace(this.ConnectionURL);
            }
            return this.ConnectionURL;
        }

        private static String appendTabulation(String string) {
            String[] lines;
            String result = "";
            for (String line : lines = string.split(lineTerminator)) {
                if ("" == line) continue;
                result = result + tabulation + line + lineTerminator;
            }
            return result;
        }

        private static String macAddressToString(String str) {
            String newString = new String();
            for (int i = 0; i < str.length(); i += 2) {
                newString = newString + str.substring(i, i + 2);
                if (i + 2 >= str.length()) continue;
                newString = newString + ":";
            }
            return newString;
        }

        private static String remoteDeviceToString(RemoteDevice remoteDevice) {
            String result = "RemoteDevice: \r\n";
            String address = "Bluetooth address: " + TWirelessDevice.macAddressToString(remoteDevice.getBluetoothAddress());
            result = result + tabulation + address + lineTerminator;
            String name = "Friendly name: ";
            try {
                name = name + remoteDevice.getFriendlyName(false);
                if (null == name) {
                    name = name + remoteDevice.getFriendlyName(true);
                }
            }
            catch (IOException e) {
                name = name + "No name";
                logger.error(e.toString(), e);
            }
            result = result + tabulation + name + lineTerminator;
            return result;
        }

        private static String deviceClassToString(DeviceClass deviceClass) {
            String result = "DeviceClass: \r\n";
            String major = String.format("Major: %X", deviceClass.getMajorDeviceClass());
            result = result + tabulation + major + lineTerminator;
            String minor = String.format("Minor: %X", deviceClass.getMinorDeviceClass());
            result = result + tabulation + minor + lineTerminator;
            String service = String.format("Service: %X", deviceClass.getServiceClasses());
            result = result + tabulation + service + lineTerminator;
            String description = BluetoothConsts.toString(deviceClass);
            result = result + tabulation + description + lineTerminator;
            return result;
        }

        private static String serviceRecordToString(ServiceRecord servRecord) {
            String result = "ServiceRecord: \r\n";
            String urlString = "URL: Null";
            String url = servRecord.getConnectionURL(0, false);
            if (null != url) {
                urlString = "URL: " + url;
            }
            result = result + tabulation + urlString + lineTerminator;
            try {
                int[] availableIDs = servRecord.getAttributeIDs();
                result = result + "  Available service IDs:\r\n";
                for (int j : availableIDs) {
                    DataElement dataElement = servRecord.getAttributeValue(j);
                    if (null == dataElement) continue;
                    String type = TWirelessParamToString.dataElementToString(dataElement);
                    if (256 == j) {
                        String serviceName = dataElement.getValue().toString();
                        String serviceDescription = String.format("0x%04X type(%s) service name: %s", j, type, serviceName);
                        result = result + "    " + serviceDescription + lineTerminator;
                        continue;
                    }
                    String serviceDescription = String.format("0x%04X type(%s)", j, type);
                    result = result + "    " + serviceDescription + lineTerminator;
                }
            }
            catch (ClassCastException e) {
                logger.error(e.toString(), e);
            }
            return result;
        }

        public String toString(boolean verbose) {
            String result = "WirelessDevice: \r\n";
            result = result + "  FrendlyName: " + this.friendlyName + lineTerminator;
            result = result + "  MAC address: " + this.macAddressString + lineTerminator;
            result = result + tabulation + String.format("URL (%d): ", this.serviceURLs.size()) + lineTerminator;
            for (String url : this.serviceURLs) {
                result = result + "    " + url + lineTerminator;
            }
            if (verbose) {
                result = null != this.remoteDevice ? result + TWirelessDevice.appendTabulation(TWirelessDevice.remoteDeviceToString(this.remoteDevice)) : result + "  RemoteDevice: null.\r\n";
                result = null != this.deviceClass ? result + TWirelessDevice.appendTabulation(TWirelessDevice.deviceClassToString(this.deviceClass)) : result + "  DeviceClass: null.\r\n";
            }
            return result;
        }

        public String toString() {
            return this.toString(false);
        }

        public String toStringShort() {
            return String.format("%s (%s)", this.friendlyName, this.macAddressString);
        }

        public static class TWirelessDiscoveryServices {
            public static final Logger logger = LogManager.getLogger(TWirelessDiscoveryServices.class);
            private final Object serviceSearchCompletedEvent = new Object();
            private RemoteDevice remoteDevice;
            private HashSet<ServiceRecord> serviceRecordHashSet = new HashSet();
            private static final boolean isDebug = false;
            private final DiscoveryListener listener = new DiscoveryListener(){

                @Override
                public void deviceDiscovered(RemoteDevice remoteDevice, DeviceClass deviceClass) {
                    logger.error("deviceDiscovered callback catches in impossible place!");
                }

                @Override
                public void servicesDiscovered(int transID, ServiceRecord[] serviceRecords) {
                    for (ServiceRecord serviceRecord : serviceRecords) {
                        if (serviceRecord.getHostDevice() == remoteDevice) {
                            serviceRecordHashSet.remove(serviceRecord);
                            serviceRecordHashSet.add(serviceRecord);
                            continue;
                        }
                        logger.error("Found service for unknown RemoteDevice ({" + serviceRecord.getHostDevice() + "}).");
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void serviceSearchCompleted(int transID, int respCode) {
                    Object object = serviceSearchCompletedEvent;
                    synchronized (object) {
                        serviceSearchCompletedEvent.notifyAll();
                    }
                }

                @Override
                public void inquiryCompleted(int i) {
                    logger.error("inquiryCompleted callback catches in impossible place!");
                }
            };

            public HashSet<ServiceRecord> getServiceRecordHashSet() {
                return this.serviceRecordHashSet;
            }

            public TWirelessDiscoveryServices(RemoteDevice remoteDevice) {
                this.remoteDevice = remoteDevice;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void discoverServices() throws InterruptedException, BluetoothStateException {
                int transID = 0;
                if (null == this.remoteDevice) {
                    throw new NullPointerException("Can't search services for null RemoteDevice");
                }
                logger.debug("Start discover services on {" + this.remoteDevice.toString() + "}");
                UUID[] searchUuidSet = new UUID[]{new UUID(4098L)};
                int[] attrIDSet = new int[]{256};
                Object object = this.serviceSearchCompletedEvent;
                synchronized (object) {
                    transID = LocalDevice.getLocalDevice().getDiscoveryAgent().searchServices(attrIDSet, searchUuidSet, this.remoteDevice, this.listener);
                    this.serviceSearchCompletedEvent.wait();
                }
                logger.debug("Done discover services on {" + this.remoteDevice.toString() + "} transaction {" + transID + "}.");
            }
        }
    }

    public static class TWirelessParamToString {
        public static final Logger logger = LogManager.getLogger(TWirelessParamToString.class);
        public static final String lineTerminator = "\r\n";
        public static final String tabulation = "  ";

        static <T> T[] concatWithCollection(T[] array1, T[] array2) {
            ArrayList resultList = new ArrayList(array1.length + array2.length);
            Collections.addAll(resultList, array1);
            Collections.addAll(resultList, array2);
            Object[] resultArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), 0);
            return resultList.toArray(resultArray);
        }

        private static String macAddressToString(String str) {
            String newString = "";
            for (int i = 0; i < str.length(); i += 2) {
                newString = newString + str.substring(i, i + 2);
                newString = newString + ":";
            }
            return newString;
        }

        public static String appendTabulation(String string) {
            String[] lines;
            String result = "";
            for (String line : lines = string.split(lineTerminator)) {
                if ("" == line) continue;
                result = result + tabulation + line + lineTerminator;
            }
            return result;
        }

        public static String deviceClassToString(DeviceClass deviceClass) {
            String result = "DeviceClass: \r\n";
            String major = String.format("Major: %X", deviceClass.getMajorDeviceClass());
            result = result + tabulation + major + lineTerminator;
            String minor = String.format("Minor: %X", deviceClass.getMinorDeviceClass());
            result = result + tabulation + minor + lineTerminator;
            String service = String.format("Service: %X", deviceClass.getServiceClasses());
            result = result + tabulation + service + lineTerminator;
            String description = BluetoothConsts.toString(deviceClass);
            result = result + tabulation + description + lineTerminator;
            return result;
        }

        public static String remoteDeviceToString(RemoteDevice remoteDevice) {
            String result = "RemoteDevice: \r\n";
            String address = "Bluetooth address: " + TWirelessParamToString.macAddressToString(remoteDevice.getBluetoothAddress());
            result = result + tabulation + address + lineTerminator;
            String name = "Friendly name: ";
            try {
                name = name + remoteDevice.getFriendlyName(false);
                if (null == name) {
                    name = name + remoteDevice.getFriendlyName(true);
                }
            }
            catch (IOException e) {
                name = name + "No name";
                logger.error(e.toString(), e);
            }
            result = result + tabulation + name + lineTerminator;
            return result;
        }

        public static String localDeviceToString(LocalDevice localDevice) {
            String result = "LocalDevice: \r\n";
            String address = "Bluetooth address: " + TWirelessParamToString.macAddressToString(localDevice.getBluetoothAddress());
            result = result + tabulation + address + lineTerminator;
            String name = "Friendly name: " + localDevice.getFriendlyName();
            result = result + tabulation + name + lineTerminator;
            String discoverable = "Discoverable: " + localDevice.getDiscoverable();
            result = result + tabulation + discoverable + lineTerminator;
            return result;
        }

        public static String dataElementToString(DataElement dataElement) {
            String type = "Unknown";
            switch (dataElement.getDataType()) {
                case 40: {
                    type = "BOOL";
                    break;
                }
                case 56: {
                    type = "DATALT";
                    break;
                }
                case 48: {
                    type = "DATSEQ";
                    break;
                }
                case 16: {
                    type = "INT_1";
                    break;
                }
                case 17: {
                    type = "INT_2";
                    break;
                }
                case 18: {
                    type = "INT_4";
                    break;
                }
                case 19: {
                    type = "INT_8";
                    break;
                }
                case 20: {
                    type = "INT_16";
                    break;
                }
                case 0: {
                    type = "NULL";
                    break;
                }
                case 32: {
                    type = "STRING";
                    break;
                }
                case 8: {
                    type = "U_INT_1";
                    break;
                }
                case 9: {
                    type = "U_INT_2";
                    break;
                }
                case 10: {
                    type = "U_INT_4";
                    break;
                }
                case 11: {
                    type = "U_INT_8";
                    break;
                }
                case 12: {
                    type = "U_INT_16";
                    break;
                }
                case 64: {
                    type = "URL";
                    break;
                }
                case 24: {
                    type = "UUID";
                }
            }
            return type;
        }

        public static String serviceRecordToString(ServiceRecord servRecord) {
            String result = "ServiceRecord: \r\n";
            String urlString = "URL: Null";
            String url = servRecord.getConnectionURL(0, false);
            if (null != url) {
                urlString = "URL: " + url;
            }
            result = result + tabulation + urlString + lineTerminator;
            try {
                int[] availableIDs = servRecord.getAttributeIDs();
                result = result + "  Available service IDs:\r\n";
                for (int j : availableIDs) {
                    DataElement dataElement = servRecord.getAttributeValue(j);
                    if (null == dataElement) continue;
                    String type = TWirelessParamToString.dataElementToString(dataElement);
                    if (256 == j) {
                        String serviceName = dataElement.getValue().toString();
                        String serviceDescription = String.format("0x%04X type(%s) service name: %s", j, type, serviceName);
                        result = result + "    " + serviceDescription + lineTerminator;
                        continue;
                    }
                    String serviceDescription = String.format("0x%04X type(%s)", j, type);
                    result = result + "    " + serviceDescription + lineTerminator;
                }
            }
            catch (ClassCastException e) {
                logger.error(e.toString(), e);
            }
            return result;
        }
    }
}

