/*
 * Decompiled with CFR 0.152.
 */
package com.esn.CGMServer.DEVICE.RegistratorModule;

import com.esn.CGMServer.DEVICE.RegistratorModule.TTransferBuffer;
import com.esn.CGMServer.DEVICEModule.TDEVICEModule;
import com.esn.CGMServer.Utils.TManualResetEvent;
import com.ftdichip.usb.FTDI;
import com.ftdichip.usb.FTDIUtility;
import com.ftdichip.usb.enumerated.FlowControl;
import com.ftdichip.usb.enumerated.LineDatabit;
import com.ftdichip.usb.enumerated.LineParity;
import com.ftdichip.usb.enumerated.LineStopbit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.usb.UsbClaimException;
import javax.usb.UsbDevice;
import javax.usb.UsbIrp;

public class TRegistratorModule
implements Runnable {
    private static final String FTDeviceName0 = "MIOKARD-12";
    public static final int ChannelsCount_Default = 8;
    public static final int SampleRate_Default = 500;
    public static final int[] SampleRates = new int[]{250, 500, 1000};
    public static final int Resolution_Default = 5;
    public static final int Normalizing_Delay_Default = 100;
    private static final int Command_Delay = 5;
    private static final int Command_RepeatCounter = 2;
    public static final int[] ChannelIndexTranslator = new int[]{1, 7, 0, 5, 2, 6, 3, 4};
    private TDEVICEModule Device;
    public int SamplesBuffer_SampleRate = 500;
    public int SamplesBuffer_ChannelsCount = 0;
    public boolean[] SamplesBuffer_ChannelsMask = null;
    public int SamplesBuffer_Size;
    public int SamplesBuffer_Suffix;
    public short[][] SamplesBuffer;
    public int SamplesBuffer_Position = 0;
    public int SamplesBuffer_Count = 0;
    public int SamplesBuffer_Index = 0;
    public final int SamplesBuffer_TransferBuffer_DefaultCapacity = 10000;
    public final int SamplesBuffer_SampleSize = 2;
    public boolean SamplesBuffer_flSaved = false;
    public TTransferBuffer SamplesBuffer_TransferBuffer = null;
    private short BrokenChannelWord = 0;
    private Thread thread;
    private FTDI device = null;
    public boolean flTerminated = false;
    private volatile boolean Normalizing_flStart = false;
    private volatile int Normalizing_Delay = 100;
    private long Normalizing_StopTimestamp = 0L;
    private String ProcessStatus = "";
    private static final int Reading_Initialization_Timeout = 30000;
    private static final int Reading_Timeout = 3000;
    private final TManualResetEvent Reading_Flag = new TManualResetEvent(false);
    private volatile Exception Reading_Exception = null;
    private volatile long Reading_Timestamp = 0L;

    public TRegistratorModule(TDEVICEModule pDevice) throws Exception {
        this.Device = pDevice;
    }

    public void Destroy() throws Exception {
        this.Stop();
    }

    public void Start(int SampleRate, int ChannelsCount, boolean[] ChannelsMask, int Duration2) throws Exception {
        this.Stop();
        this.SamplesBuffer_Create(SampleRate, ChannelsCount, ChannelsMask, Duration2);
        this.Reading_Exception = null;
        this.Reading_Flag.Reset();
        this.flTerminated = false;
        this.Reading_Timestamp_Update();
        this.thread = new Thread(this);
        this.thread.setPriority(10);
        this.thread.start();
        if (!this.Reading_Flag.WaitOne(30000, TimeUnit.MILLISECONDS)) {
            TDEVICEModule.log.info("Device.RegistratorModule: start timeout");
            throw new TimeoutException();
        }
        if (this.Reading_Exception != null) {
            throw this.Reading_Exception;
        }
    }

    public void Stop() throws Exception {
        this.flTerminated = true;
        if (this.thread != null) {
            this.thread.join();
        }
    }

    public boolean IsActive() {
        return this.thread != null && this.thread.isAlive();
    }

    public void Connect() throws IOException, Exception {
        this.device = null;
        try {
            Collection<UsbDevice> Devices = FTDIUtility.findFTDIDevices();
            for (UsbDevice Device2 : Devices) {
                String DeviceName;
                try {
                    DeviceName = Device2.getProductString();
                    TDEVICEModule.log.info("Device.RegistratorModule: cardiograph - " + DeviceName);
                }
                catch (Exception E) {
                    this.device = FTDI.getInstance(Device2);
                    break;
                }
                if (!DeviceName.startsWith(FTDeviceName0)) continue;
                this.device = FTDI.getInstance(Device2);
                break;
            }
        }
        catch (UsbClaimException UCE) {
            throw UCE;
        }
        catch (Exception E) {
            throw new IOException("! error: " + E.getMessage());
        }
        if (this.device == null) {
            throw new IOException("! USB device is not found");
        }
        this.device.usbPipeRead.open();
        this.device.usbPipeWrite.open();
        this.device.configureSerialPort(230400, LineDatabit.BITS_8, LineStopbit.STOP_BIT_1, LineParity.NONE, FlowControl.DISABLE_FLOW_CTRL);
    }

    public void Disconnect() {
        if (this.device != null) {
            try {
                this.device.usbPipeRead.close();
                this.device.usbPipeWrite.close();
                this.device.close();
                this.device = null;
            }
            catch (Exception E) {
                TDEVICEModule.log.debug("Device.RegistratorModule: closing device exception", E);
            }
        }
    }

    private synchronized void SetProcessStatus(String Status2) {
        this.ProcessStatus = Status2;
        if (Status2 != null) {
            TDEVICEModule.log.debug("Device.RegistratorModule: " + Status2);
        }
    }

    public synchronized String GetProcessStatus() {
        String S = this.ProcessStatus;
        this.ProcessStatus = null;
        return S;
    }

    private void SamplesBuffer_Create(int SampleRate, int ChannelsCount, boolean[] ChannelsMask, int Duration2) {
        this.SamplesBuffer_SampleRate = SampleRate;
        this.SamplesBuffer_ChannelsCount = ChannelsCount;
        this.SamplesBuffer_ChannelsMask = ChannelsMask;
        this.SamplesBuffer_Suffix = 0;
        this.SamplesBuffer_Suffix *= this.SamplesBuffer_SampleRate;
        this.SamplesBuffer_Size = Duration2 * this.SamplesBuffer_SampleRate + this.SamplesBuffer_Suffix;
        this.SamplesBuffer = new short[this.SamplesBuffer_ChannelsCount][this.SamplesBuffer_Size];
        this.SamplesBuffer_TransferBuffer = new TTransferBuffer(this.SamplesBuffer_ChannelsCount, 10000);
        this.SamplesBuffer_Reset();
    }

    public synchronized void SamplesBuffer_AddSamples(short[] Samples) {
        int I;
        for (I = 0; I < Samples.length; ++I) {
            this.SamplesBuffer[I][this.SamplesBuffer_Position] = Samples[I];
        }
        ++this.SamplesBuffer_Position;
        if (this.SamplesBuffer_Position >= this.SamplesBuffer_Size) {
            this.SamplesBuffer_Position = 0;
        }
        if (this.SamplesBuffer_Count < this.SamplesBuffer_Size) {
            ++this.SamplesBuffer_Count;
        }
        ++this.SamplesBuffer_Index;
        for (I = 0; I < Samples.length; ++I) {
            this.SamplesBuffer_TransferBuffer.Data[I][this.SamplesBuffer_TransferBuffer.Count] = Samples[I];
        }
        ++this.SamplesBuffer_TransferBuffer.Count;
        if (this.SamplesBuffer_TransferBuffer.Count == this.SamplesBuffer_TransferBuffer.Capacity) {
            this.SamplesBuffer_TransferBuffer.MissedCount += this.SamplesBuffer_TransferBuffer.Count;
            this.SamplesBuffer_TransferBuffer.Count = 0;
        }
    }

    public synchronized void SamplesBuffer_Reset() {
        this.SamplesBuffer_Position = 0;
        this.SamplesBuffer_Count = 0;
        this.SamplesBuffer_Index = 0;
        this.SamplesBuffer_TransferBuffer.Count = 0;
        this.SamplesBuffer_TransferBuffer.MissedCount = 0;
        this.SamplesBuffer_flSaved = false;
    }

    public synchronized int SamplesBuffer_GetSize() {
        return this.SamplesBuffer_Size;
    }

    public synchronized int SamplesBuffer_GetCount() {
        return this.SamplesBuffer_Count;
    }

    public synchronized void SamplesBuffer_ResetCount() {
        this.SamplesBuffer_Count = 0;
        this.SamplesBuffer_Index = 0;
        this.SamplesBuffer_flSaved = false;
    }

    public int SamplesBuffer_ConvertIndexToPosition(int Index) {
        return Index % this.SamplesBuffer_Size;
    }

    public synchronized int SamplesBuffer_GetAverageValue(int Channel2, int Position, int AverageCount) {
        int AvrSum = 0;
        for (int I = 0; I < AverageCount; ++I) {
            AvrSum += this.SamplesBuffer[Channel2][Position];
            if (++Position < this.SamplesBuffer_Size) continue;
            Position = 0;
        }
        return AvrSum / AverageCount;
    }

    public synchronized boolean SamplesBuffer_IsFilled() {
        return this.SamplesBuffer_Count == this.SamplesBuffer_Size;
    }

    public synchronized double SamplesBuffer_FillFactor() {
        return (double)this.SamplesBuffer_Count / (double)this.SamplesBuffer_Size;
    }

    public synchronized TTransferBuffer SamplesBuffer_TransferBuffer_Get(TTransferBuffer ExchangeBuffer) {
        TTransferBuffer R = this.SamplesBuffer_TransferBuffer;
        if (ExchangeBuffer != null) {
            this.SamplesBuffer_TransferBuffer = ExchangeBuffer;
            this.SamplesBuffer_TransferBuffer.Count = 0;
            this.SamplesBuffer_TransferBuffer.MissedCount = 0;
        } else {
            this.SamplesBuffer_TransferBuffer = new TTransferBuffer(this.SamplesBuffer_ChannelsCount, 10000);
        }
        return R;
    }

    public synchronized boolean SamplesBuffer_IsSaved() {
        return this.SamplesBuffer_flSaved;
    }

    public synchronized void SamplesBuffer_flSaved_Set(boolean V) {
        this.SamplesBuffer_flSaved = V;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void GetBrokenChannels(ArrayList<Integer> Result2) {
        short BCW;
        TRegistratorModule tRegistratorModule = this;
        synchronized (tRegistratorModule) {
            BCW = this.BrokenChannelWord;
            this.BrokenChannelWord = 0;
        }
        Result2.clear();
        if (BCW != 0) {
            if ((BCW & 1) == 1 && (this.SamplesBuffer_ChannelsMask == null || this.SamplesBuffer_ChannelsMask[0])) {
                Result2.add(0);
            }
            if ((BCW & 0x20) == 32 && (this.SamplesBuffer_ChannelsMask == null || this.SamplesBuffer_ChannelsMask[1])) {
                Result2.add(1);
            }
            if ((BCW & 0x80) == 128 && (this.SamplesBuffer_ChannelsMask == null || this.SamplesBuffer_ChannelsMask[2])) {
                Result2.add(2);
            }
            if ((BCW & 0x10) == 16 && (this.SamplesBuffer_ChannelsMask == null || this.SamplesBuffer_ChannelsMask[3])) {
                Result2.add(3);
            }
            if ((BCW & 2) == 2 && (this.SamplesBuffer_ChannelsMask == null || this.SamplesBuffer_ChannelsMask[4])) {
                Result2.add(4);
            }
            if ((BCW & 4) == 4 && (this.SamplesBuffer_ChannelsMask == null || this.SamplesBuffer_ChannelsMask[5])) {
                Result2.add(5);
            }
            if ((BCW & 8) == 8 && (this.SamplesBuffer_ChannelsMask == null || this.SamplesBuffer_ChannelsMask[6])) {
                Result2.add(6);
            }
            if ((BCW & 0x40) == 64 && (this.SamplesBuffer_ChannelsMask == null || this.SamplesBuffer_ChannelsMask[7])) {
                Result2.add(7);
            }
        }
    }

    public synchronized void Reset() {
        this.SamplesBuffer_Reset();
    }

    public void Normalize(int Delay) {
        this.Normalizing_Delay = Delay;
        this.Normalizing_flStart = true;
    }

    private void Reading_Timestamp_Update() {
        this.Reading_Timestamp = System.currentTimeMillis();
    }

    public boolean Reading_Timeout() {
        return System.currentTimeMillis() - this.Reading_Timestamp > 3000L;
    }

    public Exception Reading_Exception() {
        return this.Reading_Exception;
    }

    private void Reading_Initialize() throws Exception {
        UsbIrp rirp;
        int ReadCount;
        byte SampleRateCode;
        int I;
        this.SetProcessStatus("starting signal ...");
        byte[] Cmd = new byte[3];
        Cmd[0] = 85;
        Cmd[1] = 8;
        for (I = 0; I < 2; ++I) {
            this.device.write(Cmd);
            Thread.sleep(5L);
        }
        Cmd = new byte[]{85, 4};
        for (I = 0; I < 2; ++I) {
            this.device.write(Cmd);
            Thread.sleep(5L);
        }
        switch (this.SamplesBuffer_SampleRate) {
            case 250: 
            case 500: {
                SampleRateCode = 10;
                break;
            }
            case 1000: {
                SampleRateCode = 12;
                break;
            }
            default: {
                throw new IOException("unknown SampleRate, value: " + Integer.toString(this.SamplesBuffer_SampleRate));
            }
        }
        Cmd = new byte[]{85, SampleRateCode};
        for (int I2 = 0; I2 < 2; ++I2) {
            this.device.write(Cmd);
            Thread.sleep(5L);
        }
        byte[] Data = new byte[this.device.usbPipeRead.getUsbEndpoint().getUsbEndpointDescriptor().wMaxPacketSize()];
        int PurgeTuimeout = 100;
        do {
            rirp = this.device.usbPipeRead.asyncSubmit(Data);
            rirp.waitUntilComplete(100L);
        } while ((ReadCount = rirp.getActualLength() - 2) > 0);
        Cmd = new byte[]{85, 9};
        for (int I3 = 0; I3 < 2; ++I3) {
            this.device.write(Cmd);
            Thread.sleep(5L);
        }
        this.SetProcessStatus("reading signal ...");
    }

    private void Reading_Finalize() throws Exception {
        byte[] Cmd = new byte[]{85, 8};
        for (int I = 0; I < 2; ++I) {
            this.device.write(Cmd);
            Thread.sleep(5L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Reading() {
        this.SetProcessStatus("DEVICE THREAD HAS STARTED.");
        try {
            this.SetProcessStatus("connecting to the device ...");
            this.Connect();
            try {
                this.Reading_Initialize();
                byte[] Buffer = new byte[this.device.usbPipeRead.getUsbEndpoint().getUsbEndpointDescriptor().wMaxPacketSize()];
                byte HighByte = 0;
                boolean flHighByte = false;
                short[] SA = new short[this.SamplesBuffer_ChannelsCount];
                int LastCI = -1;
                while (!this.flTerminated) {
                    int I;
                    int ReadCount = this.device.usbPipeRead.syncSubmit(Buffer) - 2;
                    if (ReadCount <= 0) {
                        int Timeout = 1000;
                        Thread.sleep(1000L);
                        TDEVICEModule.log.debug("Device.RegistratorModule: re-initializing ...");
                        this.Reading_Initialize();
                        continue;
                    }
                    if (!this.Reading_Flag.HasSignalled()) {
                        this.Reading_Flag.Set();
                    }
                    this.Reading_Timestamp_Update();
                    for (int I2 = 0; I2 < ReadCount; ++I2) {
                        byte B = Buffer[2 + I2];
                        if ((B & 1) != 0 && flHighByte) {
                            flHighByte = false;
                            int CI = HighByte >> 5 & 7;
                            short V = (short)((short)((HighByte << 6 & 0x780 | B >> 1 & 0x7F) << 5) >> 5);
                            if (CI != LastCI) {
                                LastCI = CI;
                                SA[TRegistratorModule.ChannelIndexTranslator[CI]] = V;
                                if (CI != this.SamplesBuffer_ChannelsCount - 1) continue;
                                this.SamplesBuffer_AddSamples(SA);
                                continue;
                            }
                            if (CI != this.SamplesBuffer_ChannelsCount - 1 || V < 0) continue;
                            TRegistratorModule tRegistratorModule = this;
                            synchronized (tRegistratorModule) {
                                this.BrokenChannelWord = (short)(this.BrokenChannelWord | V);
                                continue;
                            }
                        }
                        HighByte = B;
                        flHighByte = true;
                    }
                    if (this.Normalizing_flStart) {
                        this.Normalizing_flStart = false;
                        byte[] Cmd = new byte[]{85, 3};
                        for (I = 0; I < 2; ++I) {
                            this.device.write(Cmd);
                            Thread.sleep(5L);
                        }
                        this.Normalizing_StopTimestamp = System.currentTimeMillis() + (long)this.Normalizing_Delay;
                        this.SetProcessStatus("normalizing ...");
                        continue;
                    }
                    if (this.Normalizing_StopTimestamp <= 0L || System.currentTimeMillis() <= this.Normalizing_StopTimestamp) continue;
                    this.Normalizing_StopTimestamp = 0L;
                    byte[] Cmd = new byte[]{85, 4};
                    for (I = 0; I < 2; ++I) {
                        this.device.write(Cmd);
                        Thread.sleep(5L);
                    }
                }
                this.Reading_Finalize();
            }
            finally {
                this.Disconnect();
            }
        }
        catch (Exception E) {
            this.Reading_Exception = E;
            this.Reading_Flag.Set();
            TDEVICEModule.log.error("Device.RegistratorModule: reading exception: " + E, E);
        }
        this.SetProcessStatus("DEVICE THREAD HAS FINISHED.");
    }

    @Override
    public void run() {
        this.Reading();
    }

    public final TDeviceInfo GetDeviceInfo() {
        try {
            Collection<UsbDevice> Devices = FTDIUtility.findFTDIDevices();
            for (UsbDevice Device2 : Devices) {
                String DeviceName;
                try {
                    DeviceName = Device2.getProductString();
                    TDEVICEModule.log.debug("Device.RegistratorModule: GetDeviceInfo().ProductString: " + DeviceName);
                }
                catch (Exception E) {
                    TDEVICEModule.log.debug("Device.RegistratorModule: GetDeviceInfo().ProductString: ?", E);
                    TDeviceInfo Result2 = new TDeviceInfo();
                    Result2.HardwareVersion = "15";
                    Result2.SerialID = "2019";
                    return Result2;
                }
                if (!DeviceName.startsWith(FTDeviceName0)) continue;
                String[] SA = DeviceName.split("__");
                TDeviceInfo Result3 = new TDeviceInfo();
                Result3.HardwareVersion = "15";
                Result3.SerialID = "2020";
                if (SA.length > 1) {
                    SA = SA[1].split("_");
                    int Version2 = Integer.parseInt(SA[0]);
                    switch (Version2) {
                        case 1: {
                            Result3.HardwareVersion = SA[1];
                            Result3.SerialID = SA[2];
                            break;
                        }
                        default: {
                            throw new IOException("unknown device info descriptor version: " + Integer.toString(Version2));
                        }
                    }
                }
                return Result3;
            }
            return null;
        }
        catch (Exception E) {
            TDEVICEModule.log.debug("Device.RegistratorModule: GetDeviceInfo().ProductString: ?", E);
            return null;
        }
    }

    public static class TDeviceInfo {
        public boolean flAttached;
        public String HardwareVersion;
        public String SerialID;
    }
}

