/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.usb;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.usb.UsbDevice;
import javax.usb.UsbException;
import javax.usb.UsbHub;
import javax.usb.UsbServices;

public final class UsbHostManager {
    public static final String JAVAX_USB_PROPERTIES_FILE = "javax.usb.properties";
    public static final String JAVAX_USB_USBSERVICES_PROPERTY = "javax.usb.services";
    private static final String PROPERTIES_FILE_NOT_FOUND = "Properties file javax.usb.properties not found.";
    private static final String PROPERTIES_FILE_IOEXCEPTION_READING = "IOException while reading properties file javax.usb.properties";
    private static final String PROPERTIES_FILE_IOEXCEPTION_CLOSING = "IOException while closing properties file javax.usb.properties";
    private static boolean propertiesLoaded = false;
    private static Properties properties = new Properties();
    private static Object propertiesLock = new Object();
    private static UsbServices usbServices = null;
    private static Object servicesLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsbServices getUsbServices() throws UsbException, SecurityException {
        Object object = servicesLock;
        synchronized (object) {
            if (null == usbServices) {
                usbServices = UsbHostManager.createUsbServices();
            }
        }
        return usbServices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties() throws UsbException, SecurityException {
        Object object = propertiesLock;
        synchronized (object) {
            if (!propertiesLoaded) {
                UsbHostManager.setupProperties();
            }
        }
        return (Properties)properties.clone();
    }

    private static UsbServices createUsbServices() throws UsbException, SecurityException {
        String className = UsbHostManager.getProperties().getProperty(JAVAX_USB_USBSERVICES_PROPERTY);
        if (null == className) {
            throw new UsbException(UsbHostManager.USBSERVICES_PROPERTY_NOT_DEFINED());
        }
        try {
            return (UsbServices)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException cnfE) {
            throw new UsbException(UsbHostManager.USBSERVICES_CLASSNOTFOUNDEXCEPTION(className) + " : " + cnfE.getMessage());
        }
        catch (ExceptionInInitializerError eiiE) {
            throw new UsbException(UsbHostManager.USBSERVICES_EXCEPTIONININITIALIZERERROR(className) + " : " + eiiE.getMessage());
        }
        catch (InstantiationException iE) {
            throw new UsbException(UsbHostManager.USBSERVICES_INSTANTIATIONEXCEPTION(className) + " : " + iE.getMessage());
        }
        catch (IllegalAccessException iaE) {
            throw new UsbException(UsbHostManager.USBSERVICES_ILLEGALACCESSEXCEPTION(className) + " : " + iaE.getMessage());
        }
        catch (ClassCastException ccE) {
            throw new UsbException(UsbHostManager.USBSERVICES_CLASSCASTEXCEPTION(className) + " : " + ccE.getMessage());
        }
    }

    private static void setupProperties() throws UsbException, SecurityException {
        InputStream i = null;
        String h = System.getProperty("java.home");
        String s = System.getProperty("file.separator");
        if (null != h && null != s) {
            try {
                i = new FileInputStream(h + s + "lib" + s + JAVAX_USB_PROPERTIES_FILE);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (null == i) {
            i = UsbHostManager.class.getClassLoader().getResourceAsStream(JAVAX_USB_PROPERTIES_FILE);
        }
        if (null == i) {
            throw new UsbException(PROPERTIES_FILE_NOT_FOUND);
        }
        try {
            properties.load(i);
        }
        catch (IOException ioE) {
            throw new UsbException("IOException while reading properties file javax.usb.properties : " + ioE.getMessage());
        }
        propertiesLoaded = true;
        try {
            i.close();
        }
        catch (IOException ioE) {
            System.err.println("IOException while closing properties file javax.usb.properties : " + ioE.getMessage());
        }
    }

    private static final String USBSERVICES_PROPERTY_NOT_DEFINED() {
        return "The property javax.usb.services is not defined as the implementation class of UsbServices";
    }

    private static final String USBSERVICES_CLASSNOTFOUNDEXCEPTION(String c) {
        return "The UsbServices implementation class " + c + " was not found";
    }

    private static final String USBSERVICES_EXCEPTIONININITIALIZERERROR(String c) {
        return "an Exception occurred during initialization of the UsbServices Class " + c;
    }

    private static final String USBSERVICES_INSTANTIATIONEXCEPTION(String c) {
        return "An Exception occurred during instantiation of the UsbServices implementation " + c;
    }

    private static final String USBSERVICES_ILLEGALACCESSEXCEPTION(String c) {
        return "An IllegalAccessException occurred while creating the UsbServices implementation " + c;
    }

    private static final String USBSERVICES_CLASSCASTEXCEPTION(String c) {
        return "The class " + c + " does not implement UsbServices";
    }

    public static UsbHub getRootUsbHub() throws UsbException {
        return UsbHostManager.getUsbServices().getRootUsbHub();
    }

    public static List<UsbDevice> getUsbDeviceList(short vendorId, short productId) throws UsbException {
        return UsbHostManager.getUsbDeviceList((UsbDevice)UsbHostManager.getUsbServices().getRootUsbHub(), vendorId, productId);
    }

    public static List<UsbDevice> getUsbDeviceList(UsbDevice usbDevice, short vendorId, short productId) throws UsbException {
        ArrayList<UsbDevice> iUsbDeviceList = new ArrayList<UsbDevice>();
        if (usbDevice == null) {
            return UsbHostManager.getUsbDeviceList((UsbDevice)UsbHostManager.getUsbServices().getRootUsbHub(), vendorId, productId);
        }
        if (vendorId == usbDevice.getUsbDeviceDescriptor().idVendor() && (productId == -1 || productId == usbDevice.getUsbDeviceDescriptor().idProduct())) {
            iUsbDeviceList.add(usbDevice);
        }
        if (usbDevice.isUsbHub()) {
            for (Object usbDeviceTemp : ((UsbHub)usbDevice).getAttachedUsbDevices()) {
                iUsbDeviceList.addAll(UsbHostManager.getUsbDeviceList((UsbDevice)usbDeviceTemp, vendorId, productId));
            }
        }
        return iUsbDeviceList;
    }

    public static List<UsbDevice> getUsbDeviceList(short vendorId, List<Short> productId) throws UsbException {
        return UsbHostManager.getUsbDeviceList((UsbDevice)UsbHostManager.getUsbServices().getRootUsbHub(), vendorId, productId);
    }

    public static List<UsbDevice> getUsbDeviceList(UsbDevice usbDevice, short vendorId, List<Short> productId) {
        ArrayList<UsbDevice> iUsbDeviceList = new ArrayList<UsbDevice>();
        if (vendorId == usbDevice.getUsbDeviceDescriptor().idVendor() && (productId.isEmpty() || productId.contains(usbDevice.getUsbDeviceDescriptor().idProduct()))) {
            iUsbDeviceList.add(usbDevice);
        }
        if (usbDevice.isUsbHub()) {
            for (Object usbDeviceTemp : ((UsbHub)usbDevice).getAttachedUsbDevices()) {
                iUsbDeviceList.addAll(UsbHostManager.getUsbDeviceList((UsbDevice)usbDeviceTemp, vendorId, productId));
            }
        }
        return iUsbDeviceList;
    }
}

