/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import java.io.IOException;
import javax.bluetooth.DataElement;
import javax.bluetooth.RemoteDevice;
import javax.bluetooth.ServiceRecord;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;

class OBEXTCPServiceRecordImpl
implements ServiceRecord {
    private String host;
    private String port;

    OBEXTCPServiceRecordImpl(ServerSocketConnection notifier) {
        try {
            this.port = String.valueOf(notifier.getLocalPort());
            this.host = notifier.getLocalAddress();
        }
        catch (IOException e) {
            this.host = null;
        }
    }

    OBEXTCPServiceRecordImpl(SocketConnection connection) {
        try {
            this.port = String.valueOf(connection.getPort());
            this.host = connection.getAddress();
        }
        catch (IOException e) {
            this.host = null;
        }
    }

    @Override
    public String getConnectionURL(int requiredSecurity, boolean mustBeMaster) {
        if (this.host == null) {
            return null;
        }
        return "tcpobex://" + this.host + ":" + this.port;
    }

    @Override
    public int[] getAttributeIDs() {
        throw new IllegalArgumentException("Not a Bluetooth ServiceRecord");
    }

    @Override
    public DataElement getAttributeValue(int attrID) {
        throw new IllegalArgumentException("Not a Bluetooth ServiceRecord");
    }

    @Override
    public RemoteDevice getHostDevice() {
        throw new IllegalArgumentException("Not a Bluetooth ServiceRecord");
    }

    @Override
    public boolean populateRecord(int[] attrIDs) throws IOException {
        throw new IllegalArgumentException("Not a Bluetooth ServiceRecord");
    }

    @Override
    public boolean setAttributeValue(int attrID, DataElement attrValue) {
        throw new IllegalArgumentException("Not a Bluetooth ServiceRecord");
    }

    @Override
    public void setDeviceServiceClasses(int classes) {
        throw new IllegalArgumentException("Not a Bluetooth ServiceRecord");
    }
}

