/*
 * Decompiled with CFR 0.152.
 */
package com.esn.CGMServer.Utils.Base64;

import com.esn.CGMServer.Utils.Base64.Base64;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private final Base64.Coder coder;
    private final int flags;
    private byte[] buffer = null;
    private int bpos = 0;
    private static byte[] EMPTY = new byte[0];

    public Base64OutputStream(OutputStream out, int flags) {
        this(out, flags, true);
    }

    public Base64OutputStream(OutputStream out, int flags, boolean encode) {
        super(out);
        this.flags = flags;
        this.coder = encode ? new Base64.Encoder(flags, null) : new Base64.Decoder(flags, null);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[1024];
        }
        if (this.bpos >= this.buffer.length) {
            this.internalWrite(this.buffer, 0, this.bpos, false);
            this.bpos = 0;
        }
        this.buffer[this.bpos++] = (byte)b;
    }

    private void flushBuffer() throws IOException {
        if (this.bpos > 0) {
            this.internalWrite(this.buffer, 0, this.bpos, false);
            this.bpos = 0;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        this.flushBuffer();
        this.internalWrite(b, off, len, false);
    }

    @Override
    public void close() throws IOException {
        IOException thrown;
        block7: {
            thrown = null;
            try {
                this.flushBuffer();
                this.internalWrite(EMPTY, 0, 0, true);
            }
            catch (IOException e) {
                thrown = e;
            }
            try {
                if ((this.flags & 0x10) == 0) {
                    this.out.close();
                } else {
                    this.out.flush();
                }
            }
            catch (IOException e) {
                if (thrown == null) break block7;
                thrown = e;
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }

    private void internalWrite(byte[] b, int off, int len, boolean finish) throws IOException {
        this.coder.output = this.embiggen(this.coder.output, this.coder.maxOutputSize(len));
        if (!this.coder.process(b, off, len, finish)) {
            throw new IOException("bad base-64");
        }
        this.out.write(this.coder.output, 0, this.coder.op);
    }

    private byte[] embiggen(byte[] b, int len) {
        if (b == null || b.length < len) {
            return new byte[len];
        }
        return b;
    }
}

