/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth.obex;

import com.intel.bluetooth.BluetoothConnectionNotifierServiceRecordAccess;
import com.intel.bluetooth.Utils;
import com.intel.bluetooth.obex.OBEXConnectionParams;
import com.intel.bluetooth.obex.OBEXServerSessionImpl;
import com.intel.bluetooth.obex.OBEXTCPServiceRecordImpl;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.microedition.io.Connection;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.StreamConnectionNotifier;
import javax.obex.Authenticator;
import javax.obex.ServerRequestHandler;
import javax.obex.SessionNotifier;

public class OBEXSessionNotifierImpl
implements SessionNotifier,
BluetoothConnectionNotifierServiceRecordAccess {
    private StreamConnectionNotifier notifier;
    private OBEXConnectionParams obexConnectionParams;
    private static final String FQCN = OBEXSessionNotifierImpl.class.getName();
    private static final Vector fqcnSet = new Vector();

    public OBEXSessionNotifierImpl(StreamConnectionNotifier notifier, OBEXConnectionParams obexConnectionParams) throws IOException, Error {
        Utils.isLegalAPICall(fqcnSet);
        this.notifier = notifier;
        this.obexConnectionParams = obexConnectionParams;
    }

    @Override
    public Connection acceptAndOpen(ServerRequestHandler handler) throws IOException {
        return this.acceptAndOpen(handler, null);
    }

    @Override
    public synchronized Connection acceptAndOpen(ServerRequestHandler handler, Authenticator auth) throws IOException {
        if (this.notifier == null) {
            throw new IOException("Session closed");
        }
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        OBEXServerSessionImpl sessionImpl = new OBEXServerSessionImpl(this.notifier.acceptAndOpen(), handler, auth, this.obexConnectionParams);
        sessionImpl.startSessionHandlerThread();
        return sessionImpl;
    }

    @Override
    public void close() throws IOException {
        StreamConnectionNotifier n = this.notifier;
        this.notifier = null;
        if (n != null) {
            n.close();
        }
    }

    @Override
    public ServiceRecord getServiceRecord() {
        if (this.notifier instanceof ServerSocketConnection) {
            return new OBEXTCPServiceRecordImpl((ServerSocketConnection)this.notifier);
        }
        if (!(this.notifier instanceof BluetoothConnectionNotifierServiceRecordAccess)) {
            throw new IllegalArgumentException("connection is not a Bluetooth notifier");
        }
        return ((BluetoothConnectionNotifierServiceRecordAccess)((Object)this.notifier)).getServiceRecord();
    }

    @Override
    public void updateServiceRecord(boolean acceptAndOpen) throws ServiceRegistrationException {
        if (!(this.notifier instanceof BluetoothConnectionNotifierServiceRecordAccess)) {
            throw new IllegalArgumentException("connection is not a Bluetooth notifier");
        }
        ((BluetoothConnectionNotifierServiceRecordAccess)((Object)this.notifier)).updateServiceRecord(acceptAndOpen);
    }

    static {
        fqcnSet.addElement(FQCN);
    }
}

