/*
 * Decompiled with CFR 0.152.
 */
package javax.util;

import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbException;

public class StandardRequest {
    protected UsbDevice usbDevice = null;
    protected static final byte REQUESTTYPE_CLEAR_FEATURE = 0;
    protected static final byte REQUESTTYPE_GET_CONFIGURATION = -128;
    protected static final byte REQUESTTYPE_GET_DESCRIPTOR = -128;
    protected static final byte REQUESTTYPE_GET_INTERFACE = -127;
    protected static final byte REQUESTTYPE_GET_STATUS = -128;
    protected static final byte REQUESTTYPE_SET_ADDRESS = 0;
    protected static final byte REQUESTTYPE_SET_CONFIGURATION = 0;
    protected static final byte REQUESTTYPE_SET_DESCRIPTOR = 0;
    protected static final byte REQUESTTYPE_SET_FEATURE = 0;
    protected static final byte REQUESTTYPE_SET_INTERFACE = 1;
    protected static final byte REQUESTTYPE_SYNCH_FRAME = -126;

    public StandardRequest(UsbDevice usbDevice) {
        this.usbDevice = usbDevice;
    }

    public void clearFeature(byte recipient, short featureSelector, short target) throws UsbException, IllegalArgumentException {
        StandardRequest.clearFeature(this.usbDevice, recipient, featureSelector, target);
    }

    public byte getConfiguration() throws UsbException {
        return StandardRequest.getConfiguration(this.usbDevice);
    }

    public int getDescriptor(byte type, byte index, short langid, byte[] data) throws UsbException {
        return StandardRequest.getDescriptor(this.usbDevice, type, index, langid, data);
    }

    public byte getInterface(short interfaceNumber) throws UsbException {
        return StandardRequest.getInterface(this.usbDevice, interfaceNumber);
    }

    public short getStatus(byte recipient, short target) throws UsbException, IllegalArgumentException {
        return StandardRequest.getStatus(this.usbDevice, recipient, target);
    }

    public void setAddress(short deviceAddress) throws UsbException {
        StandardRequest.setAddress(this.usbDevice, deviceAddress);
    }

    public void setConfiguration(short configurationValue) throws UsbException {
        StandardRequest.setConfiguration(this.usbDevice, configurationValue);
    }

    public int setDescriptor(byte type, byte index, short langid, byte[] data) throws UsbException {
        return StandardRequest.setDescriptor(this.usbDevice, type, index, langid, data);
    }

    public void setFeature(byte recipient, short featureSelector, short target) throws UsbException, IllegalArgumentException {
        StandardRequest.setFeature(this.usbDevice, recipient, featureSelector, target);
    }

    public void setInterface(short interfaceNumber, short alternateSetting) throws UsbException {
        StandardRequest.setInterface(this.usbDevice, interfaceNumber, alternateSetting);
    }

    public short synchFrame(short endpointAddress) throws UsbException {
        return StandardRequest.synchFrame(this.usbDevice, endpointAddress);
    }

    public static void clearFeature(UsbDevice usbDevice, byte recipient, short featureSelector, short target) throws UsbException, IllegalArgumentException {
        StandardRequest.checkRecipient(recipient);
        if (0 == recipient && 0 != target) {
            throw new IllegalArgumentException("If the recipient is device, the target must be 0");
        }
        byte bmRequestType = (byte)(0 | recipient);
        byte bRequest = 1;
        short wValue = featureSelector;
        short wIndex = target;
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex));
    }

    public static byte getConfiguration(UsbDevice usbDevice) throws UsbException {
        byte bmRequestType = -128;
        byte bRequest = 8;
        short wValue = 0;
        short wIndex = 0;
        byte[] data = new byte[1];
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        usbControlIrp.setData(data);
        usbControlIrp.setAcceptShortPacket(false);
        usbDevice.syncSubmit(usbControlIrp);
        return data[0];
    }

    public static int getDescriptor(UsbDevice usbDevice, byte type, byte index, short langid, byte[] data) throws UsbException {
        byte bmRequestType = -128;
        byte bRequest = 6;
        short wValue = (short)(type << 8 | index & 0xFF);
        short wIndex = langid;
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        usbControlIrp.setData(data);
        usbDevice.syncSubmit(usbControlIrp);
        return usbControlIrp.getActualLength();
    }

    public static byte getInterface(UsbDevice usbDevice, short interfaceNumber) throws UsbException {
        byte bmRequestType = -127;
        byte bRequest = 10;
        short wValue = 0;
        short wIndex = interfaceNumber;
        byte[] data = new byte[1];
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        usbControlIrp.setData(data);
        usbControlIrp.setAcceptShortPacket(false);
        usbDevice.syncSubmit(usbControlIrp);
        return data[0];
    }

    public static short getStatus(UsbDevice usbDevice, byte recipient, short target) throws UsbException, IllegalArgumentException {
        StandardRequest.checkRecipient(recipient);
        if (0 == recipient && 0 != target) {
            throw new IllegalArgumentException("If the recipient is device, the target must be 0");
        }
        byte bmRequestType = (byte)(0xFFFFFF80 | recipient);
        byte bRequest = 0;
        short wValue = 0;
        short wIndex = target;
        byte[] data = new byte[2];
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        usbControlIrp.setData(data);
        usbControlIrp.setAcceptShortPacket(false);
        usbDevice.syncSubmit(usbControlIrp);
        return (short)(data[1] << 8 | data[0]);
    }

    public static void setAddress(UsbDevice usbDevice, short deviceAddress) throws UsbException {
        byte bmRequestType = 0;
        byte bRequest = 5;
        short wValue = deviceAddress;
        short wIndex = 0;
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex));
    }

    public static void setConfiguration(UsbDevice usbDevice, short configurationValue) throws UsbException {
        byte bmRequestType = 0;
        byte bRequest = 9;
        short wValue = configurationValue;
        short wIndex = 0;
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex));
    }

    public static int setDescriptor(UsbDevice usbDevice, byte type, byte index, short langid, byte[] data) throws UsbException {
        byte bmRequestType = 0;
        byte bRequest = 7;
        short wValue = (short)(type << 8 | index);
        short wIndex = langid;
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        usbControlIrp.setData(data);
        usbDevice.syncSubmit(usbControlIrp);
        return usbControlIrp.getActualLength();
    }

    public static void setFeature(UsbDevice usbDevice, byte recipient, short featureSelector, short target) throws UsbException, IllegalArgumentException {
        StandardRequest.checkRecipient(recipient);
        byte bmRequestType = (byte)(0 | recipient);
        byte bRequest = 3;
        short wValue = featureSelector;
        short wIndex = target;
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex));
    }

    public static void setInterface(UsbDevice usbDevice, short interfaceNumber, short alternateSetting) throws UsbException {
        byte bmRequestType = 1;
        byte bRequest = 11;
        short wValue = alternateSetting;
        short wIndex = interfaceNumber;
        usbDevice.syncSubmit(usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex));
    }

    public static short synchFrame(UsbDevice usbDevice, short endpointAddress) throws UsbException {
        byte bmRequestType = -126;
        byte bRequest = 12;
        short wValue = 0;
        short wIndex = endpointAddress;
        byte[] data = new byte[2];
        UsbControlIrp usbControlIrp = usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        usbControlIrp.setData(data);
        usbControlIrp.setAcceptShortPacket(false);
        usbDevice.syncSubmit(usbControlIrp);
        return (short)(data[1] << 8 | data[0]);
    }

    protected static void checkRecipient(byte recipient) throws IllegalArgumentException {
        switch (recipient) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Recipient must be device (0x00), interface (0x01), or endpoint (0x02)");
            }
        }
    }
}

