/*
 * Decompiled with CFR 0.152.
 */
package javax.util;

import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.usb.UsbConfiguration;
import javax.usb.UsbConst;
import javax.usb.UsbControlIrp;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbIrp;
import javax.usb.UsbNotActiveException;
import javax.usb.UsbNotClaimedException;
import javax.usb.UsbNotOpenException;
import javax.usb.UsbPipe;
import javax.usb.UsbPort;
import javax.usb.UsbStringDescriptor;
import javax.usb.event.UsbDeviceListener;
import javax.usb.event.UsbPipeListener;
import org.usb4java.javax.Pipe;

public class UsbUtil {
    public static short unsignedShort(byte b) {
        return (short)(0xFF & b);
    }

    public static int unsignedInt(byte b) {
        return 0xFF & b;
    }

    public static int unsignedInt(short s) {
        return 0xFFFF & s;
    }

    public static long unsignedLong(byte b) {
        return 0xFF & b;
    }

    public static long unsignedLong(short s) {
        return 0xFFFF & s;
    }

    public static long unsignedLong(int i) {
        return 0xFFFFFFFF & i;
    }

    public static short toShort(byte msb, byte lsb) {
        return (short)(0xFF00 & (short)(msb << 8) | 0xFF & (short)lsb);
    }

    public static int toInt(byte byte3, byte byte2, byte byte1, byte byte0) {
        return UsbUtil.toInt(UsbUtil.toShort(byte3, byte2), UsbUtil.toShort(byte1, byte0));
    }

    public static long toLong(byte byte7, byte byte6, byte byte5, byte byte4, byte byte3, byte byte2, byte byte1, byte byte0) {
        return UsbUtil.toLong(UsbUtil.toInt(byte7, byte6, byte5, byte4), UsbUtil.toInt(byte3, byte2, byte1, byte0));
    }

    public static int toInt(short mss, short lss) {
        return 0xFFFF0000 & mss << 16 | 0xFFFF & lss;
    }

    public static long toLong(short short3, short short2, short short1, short short0) {
        return UsbUtil.toLong(UsbUtil.toInt(short3, short2), UsbUtil.toInt(short1, short0));
    }

    public static long toLong(int msi, int lsi) {
        return (long)msi << 32 | 0xFFFFFFFFFFFFFFFFL & (long)lsi;
    }

    public static String toHexString(byte b) {
        return UsbUtil.toHexString(UsbUtil.unsignedLong(b), '0', 2, 2);
    }

    public static String toHexString(short s) {
        return UsbUtil.toHexString(UsbUtil.unsignedLong(s), '0', 4, 4);
    }

    public static String toHexString(int i) {
        return UsbUtil.toHexString(UsbUtil.unsignedLong(i), '0', 8, 8);
    }

    public static String toHexString(long l) {
        return UsbUtil.toHexString(l, '0', 16, 16);
    }

    public static String toHexString(long l, char c, int min, int max) {
        StringBuffer sb = new StringBuffer(Long.toHexString(l));
        if (max < min) {
            return sb.toString();
        }
        while (sb.length() < max) {
            sb.insert(0, c);
        }
        return sb.substring(sb.length() - min);
    }

    public static String toHexString(String delimiter, byte[] array, int length) {
        StringBuffer sB = new StringBuffer();
        if (length > array.length) {
            length = array.length;
        }
        if (length < 0) {
            length = 0;
        }
        for (int i = 0; i < length; ++i) {
            sB.append(delimiter + UsbUtil.toHexString(array[i]));
        }
        return sB.toString();
    }

    public static String toHexString(String delimiter, short[] array, int length) {
        StringBuffer sB = new StringBuffer();
        if (length > array.length) {
            length = array.length;
        }
        if (length < 0) {
            length = 0;
        }
        for (int i = 0; i < length; ++i) {
            sB.append(delimiter + UsbUtil.toHexString(array[i]));
        }
        return sB.toString();
    }

    public static String toHexString(String delimiter, int[] array, int length) {
        StringBuffer sB = new StringBuffer();
        if (length > array.length) {
            length = array.length;
        }
        if (length < 0) {
            length = 0;
        }
        for (int i = 0; i < length; ++i) {
            sB.append(delimiter + UsbUtil.toHexString(array[i]));
        }
        return sB.toString();
    }

    public static String toHexString(String delimiter, long[] array, int length) {
        StringBuffer sB = new StringBuffer();
        if (length > array.length) {
            length = array.length;
        }
        if (length < 0) {
            length = 0;
        }
        for (int i = 0; i < length; ++i) {
            sB.append(delimiter + UsbUtil.toHexString(array[i]));
        }
        return sB.toString();
    }

    public static String toHexString(String delimiter, byte[] array) {
        return UsbUtil.toHexString(delimiter, array, array.length);
    }

    public static String toHexString(String delimiter, short[] array) {
        return UsbUtil.toHexString(delimiter, array, array.length);
    }

    public static String toHexString(String delimiter, int[] array) {
        return UsbUtil.toHexString(delimiter, array, array.length);
    }

    public static String toHexString(String delimiter, long[] array) {
        return UsbUtil.toHexString(delimiter, array, array.length);
    }

    public static String getSpeedString(Object object) {
        if (UsbConst.DEVICE_SPEED_LOW == object) {
            return "Low";
        }
        if (UsbConst.DEVICE_SPEED_FULL == object) {
            return "Full";
        }
        if (UsbConst.DEVICE_SPEED_UNKNOWN == object) {
            return "Unknown";
        }
        if (null == object) {
            return "null";
        }
        return "Invalid";
    }

    public static UsbDevice synchronizedUsbDevice(UsbDevice usbDevice) {
        return new SynchronizedUsbDevice(usbDevice);
    }

    public static UsbPipe synchronizedUsbPipe(UsbPipe usbPipe) {
        return new SynchronizedUsbPipe(usbPipe);
    }

    public static class SynchronizedUsbPipe
    implements UsbPipe {
        public UsbPipe usbPipe = null;
        protected Object openLock = new Object();
        protected Object submitLock = new Object();

        public SynchronizedUsbPipe(UsbPipe usbPipe) {
            this.usbPipe = usbPipe;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void open() throws UsbException, UsbNotActiveException, UsbNotClaimedException {
            Object object = this.openLock;
            synchronized (object) {
                this.usbPipe.open();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws UsbException, UsbNotOpenException {
            Object object = this.openLock;
            synchronized (object) {
                this.usbPipe.close();
            }
        }

        @Override
        public boolean isActive() {
            return this.usbPipe.isActive();
        }

        @Override
        public boolean isOpen() {
            return this.usbPipe.isOpen();
        }

        @Override
        public UsbEndpoint getUsbEndpoint() {
            return this.usbPipe.getUsbEndpoint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int syncSubmit(byte[] data) throws UsbException, UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbPipe.syncSubmit(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UsbIrp asyncSubmit(byte[] data) throws UsbException, UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbPipe.asyncSubmit(data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void syncSubmit(UsbIrp irp) throws UsbException, UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbPipe.syncSubmit(irp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asyncSubmit(UsbIrp irp) throws UsbException, UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbPipe.asyncSubmit(irp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void syncSubmit(List list) throws UsbException, UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbPipe.syncSubmit(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asyncSubmit(List list) throws UsbException, UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbPipe.asyncSubmit(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abortAllSubmissions() throws UsbNotOpenException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbPipe.abortAllSubmissions();
            }
        }

        @Override
        public UsbIrp createUsbIrp() {
            return this.usbPipe.createUsbIrp();
        }

        @Override
        public UsbControlIrp createUsbControlIrp(byte bmRequestType, byte bRequest, short wValue, short wIndex) {
            return this.usbPipe.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        }

        @Override
        public void addUsbPipeListener(UsbPipeListener listener) {
            this.usbPipe.addUsbPipeListener(listener);
        }

        @Override
        public void removeUsbPipeListener(UsbPipeListener listener) {
            this.usbPipe.removeUsbPipeListener(listener);
        }

        @Override
        public Pipe GetPipe() {
            return null;
        }
    }

    public static class SynchronizedUsbDevice
    implements UsbDevice {
        public UsbDevice usbDevice = null;
        protected Object submitLock = new Object();
        protected Object listenerLock = new Object();

        public SynchronizedUsbDevice(UsbDevice usbDevice) {
            this.usbDevice = usbDevice;
        }

        @Override
        public UsbPort getParentUsbPort() {
            return this.usbDevice.getParentUsbPort();
        }

        @Override
        public boolean isUsbHub() {
            return this.usbDevice.isUsbHub();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getManufacturerString() throws UsbException, UnsupportedEncodingException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbDevice.getManufacturerString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getSerialNumberString() throws UsbException, UnsupportedEncodingException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbDevice.getSerialNumberString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getProductString() throws UsbException, UnsupportedEncodingException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbDevice.getProductString();
            }
        }

        @Override
        public Object getSpeed() {
            return this.usbDevice.getSpeed();
        }

        @Override
        public List getUsbConfigurations() {
            return this.usbDevice.getUsbConfigurations();
        }

        @Override
        public UsbConfiguration getUsbConfiguration(byte number) {
            return this.usbDevice.getUsbConfiguration(number);
        }

        @Override
        public boolean containsUsbConfiguration(byte number) {
            return this.usbDevice.containsUsbConfiguration(number);
        }

        @Override
        public byte getActiveUsbConfigurationNumber() {
            return this.usbDevice.getActiveUsbConfigurationNumber();
        }

        @Override
        public UsbConfiguration getActiveUsbConfiguration() {
            return this.usbDevice.getActiveUsbConfiguration();
        }

        @Override
        public boolean isConfigured() {
            return this.usbDevice.isConfigured();
        }

        @Override
        public UsbDeviceDescriptor getUsbDeviceDescriptor() {
            return this.usbDevice.getUsbDeviceDescriptor();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UsbStringDescriptor getUsbStringDescriptor(byte index) throws UsbException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbDevice.getUsbStringDescriptor(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getString(byte index) throws UsbException, UnsupportedEncodingException {
            Object object = this.submitLock;
            synchronized (object) {
                return this.usbDevice.getString(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void syncSubmit(UsbControlIrp irp) throws UsbException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbDevice.syncSubmit(irp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asyncSubmit(UsbControlIrp irp) throws UsbException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbDevice.asyncSubmit(irp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void syncSubmit(List list) throws UsbException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbDevice.syncSubmit(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asyncSubmit(List list) throws UsbException {
            Object object = this.submitLock;
            synchronized (object) {
                this.usbDevice.asyncSubmit(list);
            }
        }

        @Override
        public UsbControlIrp createUsbControlIrp(byte bmRequestType, byte bRequest, short wValue, short wIndex) {
            return this.usbDevice.createUsbControlIrp(bmRequestType, bRequest, wValue, wIndex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addUsbDeviceListener(UsbDeviceListener listener) {
            Object object = this.listenerLock;
            synchronized (object) {
                this.usbDevice.addUsbDeviceListener(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeUsbDeviceListener(UsbDeviceListener listener) {
            Object object = this.listenerLock;
            synchronized (object) {
                this.usbDevice.removeUsbDeviceListener(listener);
            }
        }
    }
}

