/*
 * Decompiled with CFR 0.152.
 */
package com.esn.CGMServer.DEVICE.ServerModule;

import com.esn.CGMServer.DEVICE.RegistratorModule.Registrator.IRegistratorConnector;
import com.esn.CGMServer.DEVICE.RegistratorModule.Registrator.Types.MX2.TMX2;
import com.esn.CGMServer.DEVICE.RegistratorModule.Registrator.Types.MX2.TMX2BTConnector;
import com.esn.CGMServer.DEVICE.RegistratorModule.Registrator.Types.MX2.TMX2USBConnector;
import com.esn.CGMServer.DEVICEModule.TDEVICEModule;
import com.esn.CGMServer.Utils.OleDate;
import com.esn.CGMServer.Utils.TDataConverter;
import com.esn.CGMServer.Utils.TDateTime;
import com.esn.CGMServer.Utils.TUIDGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import org.json.JSONArray;
import org.json.JSONObject;

public class TServerModule {
    public static final int Server_DefaultPort = 2021;
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_UNKNOWN = -1;
    public static final int ERROR_INVALID_PARAMETERS = -2;
    public static final int ERROR_SESSION_NOT_FOUND = -3;
    public static final int ERROR_DEVICE_UNAVAILABLE = -4;
    public static final int ERROR_DEVICE_LOCKED = -5;
    public static final int ERROR_DEVICE_ACCESS_DENIED = -6;
    public static final int ERROR_DEVICE_TIMEOUT = -7;
    private static final int Checking_Interval = 1000;
    private final TDEVICEModule Device;
    private final TServer Server;
    private TSession Session = null;
    private int Session_Checkpoint_Interval = 0;
    private long Session_Checkpoint_Last = 0L;
    private final Timer Checking;
    public byte[] Server_ProcessClientRequest_Buffer = new byte[0];
    public byte[][] Server_ProcessClientRequest_Blocks = new byte[0][];

    public TServerModule(TDEVICEModule pDevice) throws IOException {
        this.Device = pDevice;
        this.Server = new TServer(this);
        this.Checking = new Timer(true);
        this.Checking.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                TServerModule.this.Session_Check();
            }
        }, 0L, 1000L);
    }

    public void Destroy() {
        if (this.Checking != null) {
            this.Checking.cancel();
        }
        if (this.Server != null) {
            this.Server.Destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void Server_ProcessClientRequest(InputStream IN, OutputStream OUT) throws Exception {
        int Descriptor = TServer.InputStream_ReadDescriptor(IN);
        if (Descriptor <= 0) {
            return;
        }
        byte[] RequestData = new byte[Descriptor];
        TServer.InputStream_ReadData(IN, RequestData);
        byte RequestDataType = RequestData[0];
        if (RequestDataType != 1) {
            TServer.OutputStream_WriteDescriptor(OUT, -1);
            return;
        }
        try {
            String RequestType;
            JSONObject RequestParameters = new JSONObject(new String(RequestData, 1, RequestData.length - 1, "utf-8"));
            switch (RequestType = RequestParameters.optString("Type", "")) {
                case "Check": {
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Shutdown": {
                    System.exit(-1);
                    return;
                }
                case "GetDeviceInfo": {
                    String Connector2 = RequestParameters.optString("Connector", "");
                    int Mode2 = RequestParameters.optInt("Mode", 0);
                    if (Connector2.equals("BT")) {
                        ArrayList<TMX2BTConnector.TWirelessDevice> DeviceInfo = TMX2BTConnector.GetDeviceInfo(Mode2);
                        JSONArray Result2 = new JSONArray();
                        for (TMX2BTConnector.TWirelessDevice device : DeviceInfo) {
                            JSONObject D = new JSONObject();
                            D.put("Address", device.macAddressString);
                            D.put("Name", device.friendlyName);
                            D.put("ConnectionURL", device.getConnectionURL());
                            Result2.put(D);
                        }
                        byte[] ResponseData = Result2.toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    } else {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -2).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    }
                    return;
                }
                case "Device_InterfaceModule_Check": {
                    String Connector3 = RequestParameters.optString("Connector", "");
                    if (Connector3.equals("USB")) {
                        boolean flConnected;
                        TServerModule Result2 = this;
                        synchronized (Result2) {
                            flConnected = TMX2USBConnector.CheckHolterDevice();
                        }
                        byte[] ResponseData = new JSONObject().put("Connected", flConnected ? 1 : 0).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    } else {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -2).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    }
                    return;
                }
                case "OpenSession": {
                    int PingInterval = RequestParameters.optInt("PingInterval", -1);
                    String Link = RequestParameters.optString("Link", "");
                    if (PingInterval <= 0) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -2).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    String SessionID = TUIDGenerator.Generate();
                    int ResultCode = this.Session_Open(SessionID, PingInterval, Link);
                    if (ResultCode < 0) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", ResultCode).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    byte[] ResponseData = new JSONObject().put("SessionID", SessionID).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "CloseSession": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    int ResultCode = this.Session_Close(SessionID);
                    if (ResultCode < 0) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", ResultCode).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "PingSession": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    int ResultCode = this.Session_Ping(SessionID);
                    if (ResultCode < 0) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", ResultCode).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Connect": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    this.Session = this.Session_Get(SessionID);
                    if (this.Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule D = this;
                    synchronized (D) {
                        this.Session.Holter.Device_Connect();
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Disconnect": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    this.Session = this.Session_Get(SessionID);
                    if (this.Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule D = this;
                    synchronized (D) {
                        this.Session.Holter.Device_Disconnect();
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Port_Speed_Set": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    int SpeedValue = RequestParameters.optInt("Speed", 0);
                    this.Session = this.Session_Get(SessionID);
                    if (this.Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        SpeedValue = this.Session.Holter.Device_Port_Speed_Set(SpeedValue);
                    }
                    byte[] ResponseData = new JSONObject().put("Result", SpeedValue).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_SetMode": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Session.Holter.Device_SetMode();
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Properties_Set": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    int Frequency = RequestParameters.optInt("Frequency", 0);
                    int Channels = RequestParameters.optInt("Channels", 0);
                    int Leads = RequestParameters.optInt("Leads", 0);
                    boolean flReoChannel = RequestParameters.optBoolean("Leads", false);
                    boolean flMovementChannel = RequestParameters.optBoolean("flMovementChannel", false);
                    boolean flRecording = RequestParameters.optBoolean("flRecording", false);
                    boolean flIVR = RequestParameters.optBoolean("flIVR", false);
                    boolean flDisplayOn = RequestParameters.optBoolean("flDisplayOn", false);
                    boolean flControllingFilter50Hz = RequestParameters.optBoolean("flControllingFilter50Hz", false);
                    boolean flUnreadStorage = RequestParameters.optBoolean("flUnreadStorage", false);
                    boolean flDisplayLightOn = RequestParameters.optBoolean("flDisplayLightOn", false);
                    boolean flBrokenLeadsControlIsSet = RequestParameters.optBoolean("flBrokenLeadsControlIsSet", false);
                    boolean flLowPowerConsumption = RequestParameters.optBoolean("flLowPowerConsumption", false);
                    boolean flLeadsMode2 = RequestParameters.optBoolean("flLeadsMode2", false);
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Session.Holter.Frequency = Frequency;
                        Session.Holter.Channels = Channels;
                        Session.Holter.Leads = Leads;
                        Session.Holter.flReoChannel = flReoChannel;
                        Session.Holter.flMovementChannel = flMovementChannel;
                        Session.Holter.flRecording = flRecording;
                        Session.Holter.flIVR = flIVR;
                        Session.Holter.flDisplayOn = flDisplayOn;
                        Session.Holter.flControllingFilter50Hz = flControllingFilter50Hz;
                        Session.Holter.flUnreadStorage = flUnreadStorage;
                        Session.Holter.flDisplayLightOn = flDisplayLightOn;
                        Session.Holter.flBrokenLeadsControlIsSet = flBrokenLeadsControlIsSet;
                        Session.Holter.flLowPowerConsumption = flLowPowerConsumption;
                        Session.Holter.flLeadsMode2 = flLeadsMode2;
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Properties_Get": {
                    boolean flLeadsMode2;
                    boolean flLowPowerConsumption;
                    boolean flBrokenLeadsControlIsSet;
                    boolean flDisplayLightOn;
                    boolean flUnreadStorage;
                    boolean flControllingFilter50Hz;
                    boolean flDisplayOn;
                    boolean flIVR;
                    boolean flRecording;
                    boolean flMovementChannel;
                    boolean flReoChannel;
                    int Leads;
                    int Channels;
                    int Frequency;
                    int DevicePortSpeed;
                    int DeviceStorageType;
                    int DeviceHardwareStatus;
                    long DeviceID;
                    int DeviceSWVersion;
                    short DeviceType;
                    int DeviceHWVersion;
                    int DeviceManufacturer;
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        DeviceManufacturer = Session.Holter.DeviceManufacturer;
                        DeviceHWVersion = Session.Holter.DeviceHWVersion;
                        DeviceType = Session.Holter.DeviceType;
                        DeviceSWVersion = Session.Holter.DeviceSWVersion;
                        DeviceID = Session.Holter.DeviceID;
                        DeviceHardwareStatus = Session.Holter.DeviceHardwareStatus;
                        DeviceStorageType = Session.Holter.DeviceStorageType;
                        DevicePortSpeed = Session.Holter.DevicePortSpeed;
                        Frequency = Session.Holter.Frequency;
                        Channels = Session.Holter.Channels;
                        Leads = Session.Holter.Leads;
                        flReoChannel = Session.Holter.flReoChannel;
                        flMovementChannel = Session.Holter.flMovementChannel;
                        flRecording = Session.Holter.flRecording;
                        flIVR = Session.Holter.flIVR;
                        flDisplayOn = Session.Holter.flDisplayOn;
                        flControllingFilter50Hz = Session.Holter.flControllingFilter50Hz;
                        flUnreadStorage = Session.Holter.flUnreadStorage;
                        flDisplayLightOn = Session.Holter.flDisplayLightOn;
                        flBrokenLeadsControlIsSet = Session.Holter.flBrokenLeadsControlIsSet;
                        flLowPowerConsumption = Session.Holter.flLowPowerConsumption;
                        flLeadsMode2 = Session.Holter.flLeadsMode2;
                    }
                    byte[] ResponseData = new JSONObject().put("DeviceManufacturer", DeviceManufacturer).put("DeviceHWVersion", DeviceHWVersion).put("DeviceType", DeviceType).put("DeviceSWVersion", DeviceSWVersion).put("DeviceID", DeviceID).put("DeviceHardwareStatus", DeviceHardwareStatus).put("DeviceStorageType", DeviceStorageType).put("DevicePortSpeed", DevicePortSpeed).put("Frequency", Frequency).put("Channels", Channels).put("Leads", Leads).put("flReoChannel", flReoChannel).put("flMovementChannel", flMovementChannel).put("flRecording", flRecording).put("flIVR", flIVR).put("flDisplayOn", flDisplayOn).put("flControllingFilter50Hz", flControllingFilter50Hz).put("flUnreadStorage", flUnreadStorage).put("flDisplayLightOn", flDisplayLightOn).put("flBrokenLeadsControlIsSet", flBrokenLeadsControlIsSet).put("flLowPowerConsumption", flLowPowerConsumption).put("flLeadsMode2", flLeadsMode2).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_InterfaceModule_GetData": {
                    int Data;
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Data = Session.Holter.Device_InterfaceModule_GetData();
                    }
                    byte[] ResponseData = new JSONObject().put("Data", Data).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Clock_SetTime": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    double TimeValue = RequestParameters.optDouble("Time", 0.0);
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Session.Holter.Device_Clock_SetTime(new OleDate(TimeValue));
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Clock_GetTime": {
                    TDateTime Time;
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Time = Session.Holter.Device_Clock_GetTime();
                    }
                    byte[] ResponseData = new JSONObject().put("Time", new OleDate(Time.GetDateTime()).toDouble()).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Battery_GetState": {
                    TMX2.TBatteryState BatteryState;
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        BatteryState = Session.Holter.Device_Battery_GetState();
                    }
                    byte[] ResponseData = new JSONObject().put("Ubat1", BatteryState.Ubat1).put("Ubat2", BatteryState.Ubat2).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Display_SwitchLight": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    boolean flOn = RequestParameters.optBoolean("flOn", false);
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Session.Holter.Device_Display_SwitchLight(flOn);
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Storage_Clear": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        try {
                            Session.Holter.Device_Storage_Clear();
                        }
                        finally {
                            this.Session_Ping(SessionID);
                        }
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Storage_GetType": {
                    int DeviceStorageType;
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        DeviceStorageType = Session.Holter.Device_Storage_GetType();
                    }
                    byte[] ResponseData = new JSONObject().put("Type", DeviceStorageType).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Storage_GetState": {
                    int DeviceStorageState;
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        DeviceStorageState = Session.Holter.Device_Storage_GetState();
                    }
                    byte[] ResponseData = new JSONObject().put("State", DeviceStorageState).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Storage_GetWatermark": {
                    TMX2.TStorageWatermark StorageWatermark;
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        StorageWatermark = Session.Holter.Device_Storage_GetWatermark();
                    }
                    byte[] ResponseData = new JSONObject().put("BlockIndex", StorageWatermark.BlockIndex).put("Offset", StorageWatermark.Offset).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Storage_ResetWatermark": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Session.Holter.Device_Storage_ResetWatermark();
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Storage_Recording_Start": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Session.Holter.Device_Storage_Recording_Start();
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Storage_Recording_Stop": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Session.Holter.Device_Storage_Recording_Stop();
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Storage_Recording_IsActive": {
                    boolean Active;
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Active = Session.Holter.Device_Storage_Recording_IsActive();
                    }
                    byte[] ResponseData = new JSONObject().put("Active", Active).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Storage_Recording_GetSize": {
                    TMX2.TRecordingSize RecordingSize;
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        RecordingSize = Session.Holter.Device_Storage_Recording_GetSize();
                    }
                    byte[] ResponseData = new JSONObject().put("BlockCount", RecordingSize.BlockCount).put("Offset", RecordingSize.Offset).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Storage_Recording_GetTimestamp": {
                    TDateTime Timestamp;
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Timestamp = Session.Holter.Device_Storage_Recording_GetTimestamp();
                    }
                    byte[] ResponseData = new JSONObject().put("Timestamp", new OleDate(Timestamp.GetDateTime()).toDouble()).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Storage_Recording_ReadBlocks": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    int Position = RequestParameters.optInt("Position", 0);
                    int Count = RequestParameters.optInt("Count", 0);
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        if (this.Server_ProcessClientRequest_Blocks.length != Count) {
                            this.Server_ProcessClientRequest_Blocks = new byte[Count][2052];
                        }
                        Session.Holter.Device_Storage_Recording_ReadBlocks(Position, this.Server_ProcessClientRequest_Blocks);
                        int DataLength = 1 + Count * 2052;
                        byte[] DescriptorBA = TDataConverter.ConvertInt32ToBEByteArray(DataLength);
                        OUT.write(DescriptorBA);
                        OUT.write(new byte[]{0});
                        for (int I = 0; I < Count; ++I) {
                            OUT.write(this.Server_ProcessClientRequest_Blocks[I]);
                        }
                        System.gc();
                        this.Session_Ping(SessionID);
                    }
                    return;
                }
                case "Device_Storage_Recording_MarkAsRead": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Session.Holter.Device_Storage_Recording_MarkAsRead();
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Monitoring_Start": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Session.Holter.Device_Monitoring_Start();
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Monitoring_Stop": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Session.Holter.Device_Monitoring_Stop();
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Monitoring_ReadBuffer": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    int Size = RequestParameters.optInt("Size", 0);
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule DataLength = this;
                    synchronized (DataLength) {
                        if (this.Server_ProcessClientRequest_Buffer.length < Size) {
                            this.Server_ProcessClientRequest_Buffer = new byte[Size];
                        }
                        Session.Holter.Device_Monitoring_ReadBuffer(this.Server_ProcessClientRequest_Buffer, Size);
                        int DataLength2 = 1 + Size;
                        byte[] DescriptorBA = TDataConverter.ConvertInt32ToBEByteArray(DataLength2);
                        OUT.write(DescriptorBA);
                        OUT.write(new byte[]{0});
                        OUT.write(this.Server_ProcessClientRequest_Buffer, 0, Size);
                    }
                    return;
                }
                case "Device_Monitoring_Normalize": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule DataLength = this;
                    synchronized (DataLength) {
                        Session.Holter.Device_Monitoring_Normalize();
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Monitoring_Shunt_Set": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    boolean BooleanValue = RequestParameters.optBoolean("Value", false);
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule DataLength2 = this;
                    synchronized (DataLength2) {
                        Session.Holter.Device_Monitoring_Shunt_Set(BooleanValue);
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Monitoring_50HzFilter_Set": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    boolean BooleanValue = RequestParameters.optBoolean("Value", false);
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule DataLength2 = this;
                    synchronized (DataLength2) {
                        Session.Holter.Device_Monitoring_50HzFilter_Set(BooleanValue);
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_SetBrokenLeadsControl": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    boolean BooleanValue = RequestParameters.optBoolean("Value", false);
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule DataLength2 = this;
                    synchronized (DataLength2) {
                        Session.Holter.Device_SetBrokenLeadsControl(BooleanValue);
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Patient_SetInfo": {
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TMX2.TPatientInfo PatientInfo = new TMX2.TPatientInfo();
                    PatientInfo.Name_Set(RequestParameters.optString("Name", ""));
                    PatientInfo.BirthDate = RequestParameters.optDouble("BirthDate", 0.0);
                    PatientInfo.Gender = (byte)RequestParameters.optInt("Gender", 1);
                    PatientInfo.Constitution = (byte)RequestParameters.optInt("Constitution", 0);
                    PatientInfo.Diagnose = RequestParameters.optInt("Constitution", 0);
                    PatientInfo.GUID = Base64.getDecoder().decode(RequestParameters.optString("GUID", ""));
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        Session.Holter.Device_Patient_SetInfo(PatientInfo);
                    }
                    byte[] ResponseData = new JSONObject().toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
                case "Device_Patient_GetInfo": {
                    TMX2.TPatientInfo PatientInfo;
                    String SessionID = RequestParameters.optString("SessionID", "");
                    TSession Session = this.Session_Get(SessionID);
                    if (Session == null) {
                        byte[] ResponseData = new JSONObject().put("ResultCode", -3).toString().getBytes(StandardCharsets.UTF_8);
                        TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                        return;
                    }
                    TServerModule tServerModule = this;
                    synchronized (tServerModule) {
                        PatientInfo = Session.Holter.Device_Patient_GetInfo();
                    }
                    byte[] ResponseData = new JSONObject().put("Name", PatientInfo.Name_Get()).put("BirthDate", PatientInfo.BirthDate).put("Gender", PatientInfo.Gender).put("Constitution", PatientInfo.Constitution).put("Diagnose", PatientInfo.Diagnose).put("GUID", Base64.getEncoder().encodeToString(PatientInfo.GUID)).toString().getBytes(StandardCharsets.UTF_8);
                    TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                    return;
                }
            }
        }
        catch (IOException IOE) {
            if (IOE.getCause() instanceof TimeoutException) {
                TDEVICEModule.log.error("Server_ProcessClientRequest() timeout error");
                byte[] ResponseData = new JSONObject().put("ResultCode", -7).put("ResultMessage", IOE.getCause().getLocalizedMessage()).toString().getBytes(StandardCharsets.UTF_8);
                TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                return;
            }
            if (IOE.getCause() instanceof IOException && IOE.getCause().getCause() instanceof TimeoutException) {
                TDEVICEModule.log.error("Server_ProcessClientRequest() timeout error");
                byte[] ResponseData = new JSONObject().put("ResultCode", -7).put("ResultMessage", IOE.getCause().getLocalizedMessage()).toString().getBytes(StandardCharsets.UTF_8);
                TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
                return;
            }
            byte[] ResponseData = new JSONObject().put("ResultCode", -4).put("ResultMessage", IOE.getLocalizedMessage()).toString().getBytes(StandardCharsets.UTF_8);
            TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
        }
        catch (TimeoutException TE) {
            TDEVICEModule.log.error("Server_ProcessClientRequest() timeout error");
            byte[] ResponseData = new JSONObject().put("ResultCode", -7).put("ResultMessage", TE.getLocalizedMessage()).toString().getBytes(StandardCharsets.UTF_8);
            TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
        }
        catch (Exception E) {
            TDEVICEModule.log.error("Server_ProcessClientRequest() error", E);
            byte[] ResponseData = new JSONObject().put("ResultCode", -1).put("ResultMessage", E.getLocalizedMessage()).toString().getBytes(StandardCharsets.UTF_8);
            TServer.OutputStream_WriteTypedData(OUT, (byte)1, ResponseData);
        }
    }

    public synchronized int Session_Open(String SessionID, int CheckpointInterval, String Link) throws Exception {
        try {
            if (this.Session != null && this.Session_Check()) {
                return -5;
            }
            TSession _Session = new TSession(SessionID);
            if (Link.length() == 0 || Link.startsWith("USB")) {
                _Session.Holter = new TMX2(new TMX2USBConnector());
            } else if (Link.startsWith("BT")) {
                _Session.Holter = new TMX2(new TMX2BTConnector(Link));
            } else {
                return -4;
            }
            _Session.Holter.Device_Update();
            this.Session = _Session;
            this.Session_Checkpoint_Interval = CheckpointInterval;
            this.Session_Checkpoint_Last = System.currentTimeMillis();
            TDEVICEModule.log.info("Device.ServerModule: session opened: " + this.Session.ID);
            return 0;
        }
        catch (IRegistratorConnector.RegistratorIsNotFoundException RINFE) {
            return -4;
        }
        catch (IOException IOE) {
            if (IOE.getCause() instanceof IRegistratorConnector.RegistratorIsNotFoundException) {
                return -4;
            }
            throw IOE;
        }
        catch (Exception E) {
            return -1;
        }
    }

    public synchronized int Session_Close(String SessionID) {
        try {
            if (this.Session == null || !this.Session.Equals(SessionID)) {
                return -3;
            }
            TDEVICEModule.log.info("Device.ServerModule: session closed: " + this.Session.ID);
            try {
                if (this.Session.Holter != null) {
                    this.Session.Holter.Destroy();
                }
            }
            catch (Exception E) {
                TDEVICEModule.log.info("Device.ServerModule: session closing device destroying error, session: " + this.Session.ID, E);
            }
            this.Session = null;
            this.Session_Checkpoint_Interval = 0;
            this.Session_Checkpoint_Last = 0L;
            return 0;
        }
        catch (Exception E) {
            return -1;
        }
    }

    public synchronized int Session_Ping(String SessionID) {
        if (this.Session == null || !this.Session.Equals(SessionID)) {
            return -3;
        }
        this.Session_Checkpoint_Last = System.currentTimeMillis();
        return 0;
    }

    public synchronized TSession Session_Get(String SessionID) {
        if (this.Session == null || !this.Session.Equals(SessionID)) {
            return null;
        }
        this.Session_Checkpoint_Last = System.currentTimeMillis();
        return this.Session;
    }

    public synchronized boolean Session_Check() {
        if (this.Session != null && System.currentTimeMillis() - this.Session_Checkpoint_Last > (long)(this.Session_Checkpoint_Interval << 1)) {
            this.Session_Close(this.Session.ID);
            return false;
        }
        return true;
    }

    public static class TSession {
        public final String ID;
        public TMX2 Holter = null;

        public TSession(String ID) {
            this.ID = ID;
        }

        public boolean Equals(String SessionID) {
            return this.ID.equals(SessionID);
        }
    }

    public static class TServer
    implements Runnable {
        public static final int Data_DescriptorLength = 4;
        public static final int Data_Descriptor_OK = 0;
        public static final int Data_Descriptor_Error = -1;
        public static final int Data_TypeLength = 1;
        public static final byte Data_Type_Raw = 0;
        public static final byte Data_Type_JSON = 1;
        public static final byte Data_Type_XML = 2;
        private TServerModule ServerModule;
        private final Thread thread;

        public static int InputStream_ReadData(InputStream IS, byte[] Data, int DataSize) throws IOException {
            int SummarySize;
            int Size;
            for (SummarySize = 0; SummarySize < DataSize; SummarySize += Size) {
                int ReadSize = DataSize - SummarySize;
                Size = IS.read(Data, SummarySize, ReadSize);
                if (Size > 0) continue;
                return Size;
            }
            return SummarySize;
        }

        public static int InputStream_ReadData(InputStream IS, byte[] Data) throws IOException {
            return TServer.InputStream_ReadData(IS, Data, Data.length);
        }

        public static int InputStream_ReadDescriptor(InputStream IS) throws IOException {
            byte[] DescriptorBA = new byte[4];
            TServer.InputStream_ReadData(IS, DescriptorBA);
            return TDataConverter.ConvertBEByteArrayToInt32(DescriptorBA, 0);
        }

        public static void OutputStream_WriteDescriptor(OutputStream OS, int Descriptor) throws IOException {
            byte[] DescriptorBA = TDataConverter.ConvertInt32ToBEByteArray(Descriptor);
            OS.write(DescriptorBA);
        }

        public static void OutputStream_WriteTypedData(OutputStream OS, byte DataType, byte[] Data) throws IOException {
            byte[] _Data = new byte[1 + Data.length];
            _Data[0] = DataType;
            System.arraycopy(Data, 0, _Data, 1, Data.length);
            byte[] DescriptorBA = TDataConverter.ConvertInt32ToBEByteArray(_Data.length);
            OS.write(DescriptorBA);
            OS.write(_Data);
        }

        public TServer(TServerModule ServerModule) {
            this.ServerModule = ServerModule;
            this.thread = new Thread(this);
            this.thread.start();
        }

        public void Destroy() {
            this.thread.interrupt();
        }

        @Override
        public void run() {
            try (ServerSocket ListenerSocket = new ServerSocket(((TServerModule)this.ServerModule).Device.Profile.ServerModule_Port);){
                while (!this.thread.isInterrupted()) {
                    Socket socket = ListenerSocket.accept();
                    new TServerThread(this, socket).start();
                }
            }
            catch (BindException BE) {
                TDEVICEModule.log.info("ESN Holter Server is already started or its port is busy");
                System.exit(-1);
            }
            catch (Exception E) {
                TDEVICEModule.log.error("ServerModele.Server error", E);
            }
        }

        public static class TServerThread
        extends Thread {
            private TServer Server;
            private Socket socket;

            public TServerThread(TServer Server2, Socket socket) {
                this.Server = Server2;
                this.socket = socket;
            }

            @Override
            public void run() {
                try {
                    try {
                        InputStream IN = this.socket.getInputStream();
                        OutputStream OUT = this.socket.getOutputStream();
                        this.Server.ServerModule.Server_ProcessClientRequest(IN, OUT);
                        OUT.flush();
                    }
                    finally {
                        this.socket.close();
                    }
                }
                catch (Exception E) {
                    TDEVICEModule.log.error("ServerModule.Server request processing error", E);
                }
            }
        }
    }
}

