/*
 * Decompiled with CFR 0.152.
 */
package com.esn.CGMServer.DEVICEModule;

import com.esn.CGMServer.DEVICE.RegistratorModule.TRegistratorModule;
import com.esn.CGMServer.DEVICE.ServerModule.TServerModule;
import com.esn.CGMServer.DEVICEModule.TDEVICEModuleProfile;
import java.io.File;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.net.SyslogAppender;

public class TDEVICEModule {
    public static final Logger log = LogManager.getLogger("HOLTER");
    public static TDEVICEModule Device = null;
    public TDEVICEModuleProfile Profile = null;
    public TRegistratorModule RegistratorModule;
    public TServerModule ServerModule;

    public static void main(String[] args) {
        try {
            TDEVICEModuleProfile Profile = new TDEVICEModuleProfile();
            TDEVICEModule Device2 = new TDEVICEModule(Profile);
            try {
                log.info("ESN Holter Server(v071022.3) is running on port " + Integer.toString(Profile.ServerModule_Port) + " ....");
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (Throwable throwable) {
                Device2.Destroy();
                throw throwable;
            }
        }
        catch (InterruptedException Profile) {
        }
        catch (Exception E) {
            log.fatal("main() error", E);
        }
    }

    public static String Folder() {
        return new File("").getAbsolutePath();
    }

    public static TDEVICEModule CreateDevice(TDEVICEModuleProfile pProfile) throws Exception {
        TDEVICEModule.FreeDevice();
        Device = new TDEVICEModule(pProfile);
        return Device;
    }

    public static void FreeDevice() {
        if (Device != null) {
            try {
                Device.Destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Device = null;
        }
    }

    public static TDEVICEModule GetDevice() {
        return Device;
    }

    public TDEVICEModule(TDEVICEModuleProfile pProfile) throws Exception {
        File F = new File(TDEVICEModule.Folder());
        F.mkdirs();
        this.Profile = pProfile;
        PatternLayout layout = new PatternLayout("[%p] %d{ISO8601} %c %M - %m%n");
        SyslogAppender rsyslog = new SyslogAppender(null, this.Profile.Log_Server_Address + ":" + Integer.toString(this.Profile.Log_Server_Port), 8);
        rsyslog.setName("rsyslog");
        rsyslog.setLayout(layout);
        rsyslog.setThreshold(this.Profile.Log_Threshold);
        rsyslog.activateOptions();
        log.addAppender(rsyslog);
        ConsoleAppender console = new ConsoleAppender();
        console.setName("console");
        console.setLayout(layout);
        console.setThreshold(this.Profile.Log_Threshold);
        console.activateOptions();
        log.addAppender(console);
        this.RegistratorModule = new TRegistratorModule(this);
        this.ServerModule = new TServerModule(this);
    }

    public void Destroy() throws Exception {
        if (this.ServerModule != null) {
            this.ServerModule.Destroy();
        }
        if (this.RegistratorModule != null) {
            this.RegistratorModule.Destroy();
        }
    }
}

