/*
 * Decompiled with CFR 0.152.
 */
package com.esn.CGMServer.DEVICEModule;

import com.esn.CGMServer.DEVICEModule.TDEVICEModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Level;

public class TDEVICEModuleProfile {
    public static final String FileName = "ESNHolterServer.properties";
    public Level Log_Threshold = Level.INFO;
    public String Log_Server_Address = "127.0.0.1";
    public int Log_Server_Port = 514;
    public int ServerModule_Port = 2021;

    public TDEVICEModuleProfile() {
        this.Load();
    }

    private void Load() {
        block24: {
            try {
                File IN = new File(TDEVICEModule.Folder() + "/" + FileName);
                if (IN.exists()) {
                    try (FileInputStream IS = new FileInputStream(IN);){
                        Properties props = new Properties();
                        props.load(IS);
                        System.out.println("Device profile is loaded: " + IN.getAbsolutePath());
                        System.out.println("");
                        String S = props.getProperty("Log.Threshold", "INFO");
                        if (S.equalsIgnoreCase("FATAL")) {
                            this.Log_Threshold = Level.FATAL;
                        } else if (S.equalsIgnoreCase("ERROR")) {
                            this.Log_Threshold = Level.ERROR;
                        } else if (S.equalsIgnoreCase("WARN")) {
                            this.Log_Threshold = Level.WARN;
                        } else if (S.equalsIgnoreCase("INFO")) {
                            this.Log_Threshold = Level.INFO;
                        } else if (S.equalsIgnoreCase("DEBUG")) {
                            this.Log_Threshold = Level.DEBUG;
                        }
                        System.out.println("    Log.Threshold: " + S);
                        this.Log_Server_Address = props.getProperty("Log.Server.Address", "127.0.0.1");
                        System.out.println("    Log.Server.Address: " + this.Log_Server_Address);
                        S = props.getProperty("Log.Server.Port", "514");
                        this.Log_Server_Port = Integer.parseInt(S);
                        System.out.println("    Log.Server.Port: " + Integer.toString(this.Log_Server_Port));
                        S = props.getProperty("ServerModule.Port", Integer.toString(2021));
                        this.ServerModule_Port = Integer.parseInt(S);
                        System.out.println("    ServerModule.Port: " + Integer.toString(this.ServerModule_Port));
                        System.out.println("");
                        break block24;
                    }
                }
                System.out.println("!!! device profile is not found !!!");
            }
            catch (IOException | NumberFormatException E) {
                System.out.println("! error of loading device profile: " + E.getMessage());
                System.exit(0);
            }
        }
    }
}

