/*
 * Decompiled with CFR 0.152.
 */
package com.esn.CGMServer.Utils;

import com.esn.CGMServer.Utils.TDateTime;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class OleDate
extends TDateTime {
    private static double UTCOffsetValue;
    private static boolean UTCOffset_flCalculated;
    private static final double HALF_SECOND = 5.787037037037037E-6;
    private int[] rgMonthDays = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};

    public static double UTCCurrentTimestamp() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        return new OleDate(c.get(1), c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13), c.get(14)).toDouble();
    }

    private static double UTCOffset() {
        if (!UTCOffset_flCalculated) {
            TimeZone tz = TimeZone.getDefault();
            Date now = new Date();
            UTCOffsetValue = (double)tz.getOffset(now.getTime()) / 8.64E7;
            UTCOffset_flCalculated = true;
        }
        return UTCOffsetValue;
    }

    public static double UTCToLocalTime(double UTCTime) {
        return UTCTime + OleDate.UTCOffset();
    }

    public static double LocalTimeToUTC(double LocalTime) {
        return LocalTime - OleDate.UTCOffset();
    }

    public static String Format(String Format2, TimeZone ValueTimeZone, double Value) {
        SimpleDateFormat SDF = new SimpleDateFormat(Format2, Locale.US);
        SDF.setTimeZone(ValueTimeZone);
        return SDF.format(new OleDate(Value).GetDateTime());
    }

    public static String Format(String Format2, double Value) {
        return OleDate.Format(Format2, TimeZone.getTimeZone("UTC"), Value);
    }

    public OleDate() {
    }

    public OleDate(int year, int month, int date, int hrs, int min, int sec, int millisec) {
        super(year, month, date, hrs, min, sec, millisec);
    }

    public OleDate(Date DateTime) {
        super(DateTime);
    }

    public OleDate(double date) {
        this.setDate(date);
    }

    public OleDate(double date, boolean flConvertFromUTC) {
        if (flConvertFromUTC) {
            date = OleDate.UTCToLocalTime(date);
        }
        this.setDate(date);
    }

    public void setDate(double dtSrc) {
        int tm_hour;
        int tm_min;
        int tm_sec;
        int tm_mday;
        int tm_mon;
        long n4Yr;
        long n4Day;
        long n4Years;
        boolean bLeap4 = true;
        double dblDate = dtSrc;
        long nDaysAbsolute = (long)(dblDate += dtSrc > 0.0 ? 5.787037037037037E-6 : -5.787037037037037E-6) + 693959L;
        dblDate = Math.abs(dblDate);
        long nSecsInDay = (long)((dblDate - Math.floor(dblDate)) * 86400.0);
        long n400Years = nDaysAbsolute / 146097L;
        long n400Century = ((nDaysAbsolute %= 146097L) - 1L) / 36524L;
        if (n400Century != 0L) {
            n4Years = ((nDaysAbsolute = (nDaysAbsolute - 1L) % 36524L) + 1L) / 1461L;
            if (n4Years != 0L) {
                n4Day = (nDaysAbsolute + 1L) % 1461L;
            } else {
                bLeap4 = false;
                n4Day = nDaysAbsolute;
            }
        } else {
            n4Years = nDaysAbsolute / 1461L;
            n4Day = nDaysAbsolute % 1461L;
        }
        if (bLeap4) {
            n4Yr = (n4Day - 1L) / 365L;
            if (n4Yr != 0L) {
                n4Day = (n4Day - 1L) % 365L;
            }
        } else {
            n4Yr = n4Day / 365L;
            n4Day %= 365L;
        }
        int tm_year = (int)(n400Years * 400L + n400Century * 100L + n4Years * 4L + n4Yr);
        if (n4Yr == 0L && bLeap4 && n4Day == 59L) {
            tm_mon = 2;
            tm_mday = 29;
        } else {
            if (n4Yr == 0L && bLeap4 && n4Day >= 59L) {
                --n4Day;
            }
            tm_mon = (int)((++n4Day >> 5) + 1L);
            while (n4Day > (long)this.rgMonthDays[tm_mon]) {
                ++tm_mon;
            }
            tm_mday = (int)(n4Day - (long)this.rgMonthDays[tm_mon - 1]);
        }
        if (nSecsInDay == 0L) {
            tm_sec = 0;
            tm_min = 0;
            tm_hour = 0;
        } else {
            tm_sec = (int)(nSecsInDay % 60L);
            long nMinutesInDay = nSecsInDay / 60L;
            tm_min = (int)(nMinutesInDay % 60L);
            tm_hour = (int)(nMinutesInDay / 60L);
        }
        this.setYear(tm_year);
        this.setMonth(tm_mon);
        this.setDate(tm_mday);
        this.setHours(tm_hour);
        this.setMinutes(tm_min);
        this.setSeconds(tm_sec);
    }

    public double toDouble() {
        int wYear = this.getYear();
        int wMonth = this.getMonth();
        int wDay = this.getDate();
        int wHour = this.getHours();
        int wMinute = this.getMinutes();
        int wSecond = this.getSeconds();
        int wMillisecond = this.getMilliSeconds();
        boolean bLeapYear = (wYear & 3) == 0 && (wYear % 100 != 0 || wYear % 400 == 0);
        long nDate = (long)wYear * 365L + (long)(wYear / 4) - (long)(wYear / 100) + (long)(wYear / 400) + (long)this.rgMonthDays[wMonth - 1] + (long)wDay;
        if (wMonth <= 2 && bLeapYear) {
            --nDate;
        }
        double dblTime = (double)((long)wHour * 3600L + (long)wMinute * 60L + (long)wSecond) / 86400.0;
        double dtDest = (double)(nDate -= 693959L) + (nDate >= 0L ? dblTime : -dblTime);
        return dtDest += (double)wMillisecond * 1.1574074074074074E-8;
    }

    static {
        UTCOffset_flCalculated = false;
    }
}

