/*
 * Decompiled with CFR 0.152.
 */
package com.ftdichip.usb;

import com.ftdichip.usb.EEndpointDirection;

public class BMRequestType {
    private final EEndpointDirection direction;
    private final EType type;
    private final ERecipient recipient;

    public BMRequestType(EEndpointDirection direction, EType type, ERecipient recipient) {
        this.direction = direction;
        this.type = type;
        this.recipient = recipient;
    }

    public BMRequestType(byte bmRequestType) {
        this.direction = EEndpointDirection.fromByte(bmRequestType);
        this.type = EType.fromByte(bmRequestType);
        this.recipient = ERecipient.fromByte(bmRequestType);
    }

    public static byte getInstanceStandardRead() {
        return new BMRequestType(EEndpointDirection.DEVICE_TO_HOST, EType.STANDARD, ERecipient.DEVICE).getByteCode();
    }

    public static byte getInstanceStandardRead(ERecipient recipient) {
        return new BMRequestType(EEndpointDirection.DEVICE_TO_HOST, EType.STANDARD, recipient).getByteCode();
    }

    public static byte getInstanceStandardWrite() {
        return new BMRequestType(EEndpointDirection.HOST_TO_DEVICE, EType.STANDARD, ERecipient.DEVICE).getByteCode();
    }

    public static byte getInstanceStandardWrite(ERecipient recipient) {
        return new BMRequestType(EEndpointDirection.HOST_TO_DEVICE, EType.STANDARD, recipient).getByteCode();
    }

    public byte getByteCode() {
        return (byte)(this.direction.getByteCode() | this.type.getByteCode() | this.recipient.getByteCode());
    }

    public EEndpointDirection getDirection() {
        return this.direction;
    }

    public EType getType() {
        return this.type;
    }

    public ERecipient getRecipient() {
        return this.recipient;
    }

    public String toString() {
        return "[" + (Object)((Object)this.direction) + "|" + (Object)((Object)this.type) + "|" + (Object)((Object)this.recipient) + ']';
    }

    public static enum ERecipient {
        DEVICE(0),
        INTERFACE(1),
        ENDPOINT(2),
        OTHER(3);

        private final byte byteCode;
        private static final byte MASK = 31;

        private ERecipient(byte byteCode) {
            this.byteCode = byteCode;
        }

        public static ERecipient fromByte(byte bmRequestType) {
            for (ERecipient eType : ERecipient.values()) {
                if ((bmRequestType & 0x1F) != eType.byteCode) continue;
                return eType;
            }
            return null;
        }

        public byte getByteCode() {
            return this.byteCode;
        }
    }

    public static enum EType {
        STANDARD(0),
        CLASS(32),
        VENDOR(64),
        RESERVED(96);

        private final byte byteCode;
        private static final byte MASK = 96;

        private EType(byte byteCode) {
            this.byteCode = byteCode;
        }

        public static EType fromByte(byte bmRequestType) {
            for (EType eType : EType.values()) {
                if ((bmRequestType & 0x60) != eType.byteCode) continue;
                return eType;
            }
            return null;
        }

        public byte getByteCode() {
            return this.byteCode;
        }
    }
}

