/*
 * Decompiled with CFR 0.152.
 */
package com.intel.bluetooth;

import com.intel.bluetooth.BluetoothConnectionParams;
import com.intel.bluetooth.BluetoothRFCommConnection;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.DebugLog;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.Utils;
import java.io.IOException;

class BluetoothRFCommClientConnection
extends BluetoothRFCommConnection {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BluetoothRFCommClientConnection(BluetoothStack bluetoothStack, BluetoothConnectionParams params) throws IOException {
        super(bluetoothStack, bluetoothStack.connectionRfOpenClientConnection(params));
        boolean initOK = false;
        try {
            this.securityOpt = bluetoothStack.rfGetSecurityOpt(this.handle, Utils.securityOpt(params.authenticate, params.encrypt));
            RemoteDeviceHelper.connected(this);
            initOK = true;
        }
        finally {
            if (!initOK) {
                try {
                    bluetoothStack.connectionRfCloseClientConnection(this.handle);
                }
                catch (IOException e) {
                    DebugLog.error("close error", e);
                }
            }
        }
    }

    @Override
    void closeConnectionHandle(long handle) throws IOException {
        RemoteDeviceHelper.disconnected(this);
        this.bluetoothStack.connectionRfCloseClientConnection(handle);
    }
}

