/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.usb4java.javax.descriptors.SimpleUsbDeviceDescriptor;

final class DeviceId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int busNumber;
    private final int deviceAddress;
    private final int portNumber;
    private final SimpleUsbDeviceDescriptor deviceDescriptor;

    DeviceId(int busNumber, int deviceAddress, int portNumber, SimpleUsbDeviceDescriptor deviceDescriptor) {
        if (deviceDescriptor == null) {
            throw new IllegalArgumentException("deviceDescriptor must be set");
        }
        this.busNumber = busNumber;
        this.portNumber = portNumber;
        this.deviceAddress = deviceAddress;
        this.deviceDescriptor = deviceDescriptor;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.busNumber).append(this.deviceAddress).append(this.portNumber).append(this.deviceDescriptor).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeviceId other = (DeviceId)obj;
        return new EqualsBuilder().append(this.busNumber, other.busNumber).append(this.deviceAddress, other.deviceAddress).append(this.portNumber, other.portNumber).append(this.deviceDescriptor, other.deviceDescriptor).isEquals();
    }

    public int getBusNumber() {
        return this.busNumber;
    }

    public int getDeviceAddress() {
        return this.deviceAddress;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public SimpleUsbDeviceDescriptor getDeviceDescriptor() {
        return this.deviceDescriptor;
    }

    public String toString() {
        return String.format("Bus %03d Device %03d: ID %04x:%04x", this.busNumber, this.deviceAddress, this.deviceDescriptor.idVendor(), this.deviceDescriptor.idProduct());
    }

    public static boolean equals(DeviceId a, DeviceId b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }
}

